/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import java.io.PrintStream;

public class Chronos {
    private final PrintStream _out;
    private volatile long _lastTick;
    private volatile long _startTime;

    public Chronos() {
        this(null);
    }

    public Chronos(PrintStream out) {
        this._lastTick = this._startTime = System.currentTimeMillis();
        this._out = out;
    }

    public void restart() {
        this._lastTick = this._startTime = System.currentTimeMillis();
    }

    public long tick() {
        long tick = System.currentTimeMillis();
        long diff = tick - this._lastTick;
        this._lastTick = tick;
        return diff;
    }

    public long getTotalTime() {
        return System.currentTimeMillis() - this._startTime;
    }

    public String getElapsedTime() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tick());
        sb.append(" ms");
        return sb.toString();
    }

    public void displayElapsedTime() {
        this.displayElapsedTime("");
    }

    public void displayElapsedTime(String msg) {
        if (this._out != null) {
            this._out.println(msg + this.getElapsedTime());
        }
    }

    public void flush() {
        if (this._out != null) {
            this._out.flush();
        }
    }
}

