/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBApiLayer
extends DB {
    static final boolean D = Boolean.getBoolean("DEBUG.DB");
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final int NUM_CURSORS_PER_BATCH = 20000;
    static final Logger TRACE_LOGGER = Logger.getLogger("com.mongodb.TRACE");
    static final Level TRACE_LEVEL = Boolean.getBoolean("DB.TRACE") ? Level.INFO : Level.FINEST;
    final String _root;
    final String _rootPlusDot;
    final DBConnector _connector;
    final Map<String, MyCollection> _collections = Collections.synchronizedMap(new HashMap());
    final String _deadCursorIdsLock = "DBApiLayer-_deadCursorIdsLock-" + Math.random();
    List<DeadCursor> _deadCursorIds = new LinkedList<DeadCursor>();
    static final List<DBObject> EMPTY = Collections.unmodifiableList(new LinkedList());

    static final boolean willTrace() {
        return TRACE_LOGGER.isLoggable(TRACE_LEVEL);
    }

    static final void trace(String s) {
        TRACE_LOGGER.log(TRACE_LEVEL, s);
    }

    protected DBApiLayer(Mongo mongo, String root, DBConnector connector) {
        super(mongo, root);
        if (connector == null) {
            throw new IllegalArgumentException("need a connector: " + root);
        }
        this._root = root;
        this._rootPlusDot = this._root + ".";
        this._connector = connector;
    }

    @Override
    public void requestStart() {
        this._connector.requestStart();
    }

    @Override
    public void requestDone() {
        this._connector.requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._connector.requestEnsureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MyCollection doGetCollection(String name) {
        MyCollection c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        Map<String, MyCollection> map = this._collections;
        synchronized (map) {
            c = this._collections.get(name);
            if (c != null) {
                return c;
            }
            c = new MyCollection(name);
            this._collections.put(name, c);
        }
        return c;
    }

    String _removeRoot(String ns) {
        if (!ns.startsWith(this._rootPlusDot)) {
            return ns;
        }
        return ns.substring(this._root.length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _cleanCursors(boolean force) throws MongoException {
        List<DeadCursor> l = null;
        int sz = this._deadCursorIds.size();
        if (sz == 0) {
            return;
        }
        if (!force && sz < 100) {
            return;
        }
        String string = this._deadCursorIdsLock;
        synchronized (string) {
            sz = this._deadCursorIds.size();
            if (sz == 0) {
                return;
            }
            if (!force && sz < 100) {
                return;
            }
            l = this._deadCursorIds;
            this._deadCursorIds = new LinkedList<DeadCursor>();
        }
        Bytes.LOGGER.info("going to kill cursors : " + l.size());
        HashMap<ServerAddress, LinkedList<Long>> m = new HashMap<ServerAddress, LinkedList<Long>>();
        for (DeadCursor deadCursor : l) {
            LinkedList<Long> x = (LinkedList<Long>)m.get(deadCursor.host);
            if (x == null) {
                x = new LinkedList<Long>();
                m.put(deadCursor.host, x);
            }
            x.add(deadCursor.id);
        }
        for (Map.Entry entry : m.entrySet()) {
            try {
                this.killCursors((ServerAddress)entry.getKey(), (List)entry.getValue());
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean cursors", t);
                String string2 = this._deadCursorIdsLock;
                synchronized (string2) {
                    for (Long x : (List)entry.getValue()) {
                        this._deadCursorIds.add(new DeadCursor(x, (ServerAddress)entry.getKey()));
                    }
                }
            }
        }
    }

    void killCursors(ServerAddress addr, List<Long> all) throws MongoException {
        if (all == null || all.size() == 0) {
            return;
        }
        OutMessage om = new OutMessage(this._mongo, 2007);
        om.writeInt(0);
        om.writeInt(Math.min(20000, all.size()));
        int soFar = 0;
        int totalSoFar = 0;
        for (Long l : all) {
            om.writeLong(l);
            ++totalSoFar;
            if (++soFar < 20000) continue;
            this._connector.say(this, om, WriteConcern.NONE);
            om = new OutMessage(this._mongo, 2007);
            om.writeInt(0);
            om.writeInt(Math.min(20000, all.size() - totalSoFar));
            soFar = 0;
        }
        this._connector.say(this, om, WriteConcern.NONE, addr);
    }

    class DeadCursor {
        final long id;
        final ServerAddress host;

        DeadCursor(long a, ServerAddress b) {
            this.id = a;
            this.host = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Result
    implements Iterator<DBObject> {
        Response _curResult;
        Iterator<DBObject> _cur;
        int _numToReturn;
        final MyCollection _collection;
        final int _options;
        final ServerAddress _host;
        private long _totalBytes = 0L;
        private int _numGetMores = 0;
        private List<Integer> _sizes = new ArrayList<Integer>();

        Result(MyCollection coll, Response res, int numToReturn, int options) {
            this.init(res);
            this._collection = coll;
            this._numToReturn = numToReturn;
            this._options = options;
            this._host = res._host;
        }

        private void init(Response res) {
            this._totalBytes += (long)res._len;
            this._curResult = res;
            this._cur = res.iterator();
            this._sizes.add(res.size());
            if ((res._flags & 1) > 0) {
                throw new MongoException.CursorNotFound();
            }
        }

        @Override
        public DBObject next() {
            if (this._cur.hasNext()) {
                return this._cur.next();
            }
            if (!this._curResult.hasGetMore(this._options)) {
                throw new RuntimeException("no more");
            }
            this._advance();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            while (!this._cur.hasNext()) {
                if (!this._curResult.hasGetMore(this._options)) {
                    return false;
                }
                this._advance();
            }
            return true;
        }

        private void _advance() {
            if (this._curResult.cursor() <= 0L) {
                throw new RuntimeException("can't advance a cursor <= 0");
            }
            OutMessage m = new OutMessage(DBApiLayer.this._mongo, 2005);
            m.writeInt(0);
            m.writeCString(this._collection._fullNameSpace);
            m.writeInt(this._numToReturn);
            m.writeLong(this._curResult.cursor());
            try {
                Response res = DBApiLayer.this._connector.call(DBApiLayer.this, this._collection, m, this._host);
                ++this._numGetMores;
                this.init(res);
            }
            catch (MongoException me) {
                throw new MongoInternalException("can't do getmore", me);
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("can't remove this way");
        }

        public int getNumberToReturn() {
            return this._numToReturn;
        }

        public void setNumberToReturn(int num) {
            this._numToReturn = num;
        }

        public String toString() {
            return "DBCursor";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            if (this._curResult != null && this._curResult.cursor() != 0L) {
                String string = DBApiLayer.this._deadCursorIdsLock;
                synchronized (string) {
                    DBApiLayer.this._deadCursorIds.add(new DeadCursor(this._curResult.cursor(), this._host));
                }
            }
            super.finalize();
        }

        public long totalBytes() {
            return this._totalBytes;
        }

        public long getCursorId() {
            if (this._curResult == null) {
                return 0L;
            }
            return this._curResult._cursor;
        }

        int numGetMores() {
            return this._numGetMores;
        }

        List<Integer> getSizes() {
            return Collections.unmodifiableList(this._sizes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            String string = DBApiLayer.this._deadCursorIdsLock;
            synchronized (string) {
                DBApiLayer.this._deadCursorIds.add(new DeadCursor(this._curResult.cursor(), this._host));
            }
            DBApiLayer.this._cleanCursors(true);
            this._curResult = null;
            this._cur = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyCollection
    extends DBCollection {
        final String _fullNameSpace;

        MyCollection(String name) {
            super(DBApiLayer.this, name);
            this._fullNameSpace = DBApiLayer.this._root + "." + name;
        }

        @Override
        public void doapply(DBObject o) {
        }

        @Override
        public WriteResult insert(DBObject[] arr, WriteConcern concern) throws MongoException {
            return this.insert(arr, true, concern);
        }

        protected WriteResult insert(DBObject[] arr, boolean shouldApply, WriteConcern concern) throws MongoException {
            if (DBApiLayer.willTrace()) {
                for (DBObject o : arr) {
                    DBApiLayer.trace("save:  " + this._fullNameSpace + " " + JSON.serialize(o));
                }
            }
            if (shouldApply) {
                for (int i = 0; i < arr.length; ++i) {
                    DBObject o = arr[i];
                    this.apply(o);
                    Object id = o.get("_id");
                    if (!(id instanceof ObjectId)) continue;
                    ((ObjectId)id).notNew();
                }
            }
            WriteResult last = null;
            int cur = 0;
            while (cur < arr.length) {
                OutMessage om = new OutMessage(DBApiLayer.this._mongo, 2002);
                om.writeInt(0);
                om.writeCString(this._fullNameSpace);
                while (cur < arr.length) {
                    DBObject o;
                    o = arr[cur];
                    int sz = om.putObject(o);
                    if (sz > 0x400000) {
                        throw new IllegalArgumentException("object too big: " + sz);
                    }
                    if (om.size() > 0x400000) {
                        ++cur;
                        break;
                    }
                    ++cur;
                }
                last = DBApiLayer.this._connector.say(this._db, om, concern);
            }
            return last;
        }

        @Override
        public WriteResult remove(DBObject o, WriteConcern concern) throws MongoException {
            if (DBApiLayer.willTrace()) {
                DBApiLayer.trace("remove: " + this._fullNameSpace + " " + JSON.serialize(o));
            }
            OutMessage om = new OutMessage(DBApiLayer.this._mongo, 2006);
            om.writeInt(0);
            om.writeCString(this._fullNameSpace);
            Set<String> keys = o.keySet();
            if (keys.size() == 1 && ((String)keys.iterator().next()).equals("_id") && o.get((String)keys.iterator().next()) instanceof ObjectId) {
                om.writeInt(1);
            } else {
                om.writeInt(0);
            }
            om.putObject(o);
            return DBApiLayer.this._connector.say(this._db, om, concern);
        }

        @Override
        Iterator<DBObject> __find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int options) throws MongoException {
            DBObject foo;
            MongoException e;
            if (ref == null) {
                ref = new BasicDBObject();
            }
            if (DBApiLayer.willTrace()) {
                DBApiLayer.trace("find: " + this._fullNameSpace + " " + JSON.serialize(ref));
            }
            DBApiLayer.this._cleanCursors(false);
            OutMessage query = OutMessage.query(DBApiLayer.this._mongo, options, this._fullNameSpace, numToSkip, batchSize, ref, fields);
            Response res = DBApiLayer.this._connector.call(this._db, this, query, null, 2);
            if (res.size() == 0) {
                return null;
            }
            if (res.size() == 1 && (e = MongoException.parse(foo = res.get(0))) != null && !this._name.equals("$cmd")) {
                throw e;
            }
            return new Result(this, res, batchSize, options);
        }

        @Override
        public WriteResult update(DBObject query, DBObject o, boolean upsert, boolean multi, WriteConcern concern) throws MongoException {
            if (DBApiLayer.willTrace()) {
                DBApiLayer.trace("update: " + this._fullNameSpace + " " + JSON.serialize(query));
            }
            OutMessage om = new OutMessage(DBApiLayer.this._mongo, 2001);
            om.writeInt(0);
            om.writeCString(this._fullNameSpace);
            int flags = 0;
            if (upsert) {
                flags |= 1;
            }
            if (multi) {
                flags |= 2;
            }
            om.writeInt(flags);
            om.putObject(query);
            om.putObject(o);
            return DBApiLayer.this._connector.say(this._db, om, concern);
        }

        @Override
        public void createIndex(DBObject keys, DBObject options) throws MongoException {
            BasicDBObject full = new BasicDBObject();
            for (String k : options.keySet()) {
                full.put(k, options.get(k));
            }
            full.put("key", (Object)keys);
            DBApiLayer.this.doGetCollection("system.indexes").insert(new DBObject[]{full}, false, this.getWriteConcern());
        }
    }
}

