/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.GroupProperties;
import com.hazelcast.nio.AbstractSerializer;
import com.hazelcast.nio.CustomSerializer;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import com.hazelcast.nio.TypeSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DefaultSerializer
implements CustomSerializer {
    private static final byte SERIALIZER_TYPE_OBJECT = 0;
    private static final byte SERIALIZER_TYPE_BYTE_ARRAY = 1;
    private static final byte SERIALIZER_TYPE_INTEGER = 2;
    private static final byte SERIALIZER_TYPE_LONG = 3;
    private static final byte SERIALIZER_TYPE_CLASS = 4;
    private static final byte SERIALIZER_TYPE_STRING = 5;
    private static final byte SERIALIZER_TYPE_DATE = 6;
    private static final byte SERIALIZER_TYPE_BIG_INTEGER = 7;
    private static final byte SERIALIZER_TYPE_EXTERNALIZABLE = 8;
    private static final boolean shared = GroupProperties.SERIALIZER_SHARED.getBoolean();
    private static final boolean gzipEnabled = GroupProperties.SERIALIZER_GZIP_ENABLED.getBoolean();
    private static final TypeSerializer[] serializers = DefaultSerializer.sort(new TypeSerializer[]{new ByteArraySerializer(), new LongSerializer(), new IntegerSerializer(), new StringSerializer(), new ClassSerializer(), new DateSerializer(), new BigIntegerSerializer(), new Externalizer(), new ObjectSerializer()});
    private TypeSerializer[] serializer = serializers;
    private TypeSerializer[] typeSerializer = new TypeSerializer[serializers.length];

    public static TypeSerializer[] sort(TypeSerializer[] serializers) {
        Arrays.sort(serializers, new Comparator<TypeSerializer>(){

            @Override
            public int compare(TypeSerializer o1, TypeSerializer o2) {
                int p2;
                int p1 = o1.priority();
                return p1 < (p2 = o2.priority()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        return serializers;
    }

    public DefaultSerializer() {
        for (int i = 0; i < serializers.length; ++i) {
            this.typeSerializer[DefaultSerializer.serializers[i].getTypeId()] = serializers[i];
        }
    }

    public void write(OutputStream os, Object obj) throws Exception {
        FastByteArrayOutputStream bos = (FastByteArrayOutputStream)os;
        int typeId = -1;
        for (int i = 0; i < this.serializer.length; ++i) {
            if (!this.serializer[i].isSuitable(obj)) continue;
            typeId = this.serializer[i].getTypeId();
            break;
        }
        if (typeId == -1) {
            throw new NotSerializableException("There is no suitable serializer for " + obj.getClass().getName());
        }
        bos.writeByte(typeId);
        this.typeSerializer[typeId].write(bos, obj);
    }

    public Object read(InputStream is) throws Exception {
        FastByteArrayInputStream bis = (FastByteArrayInputStream)is;
        byte typeId = bis.readByte();
        if (typeId < 0 || typeId >= this.typeSerializer.length) {
            throw new IllegalArgumentException("There is no suitable deserializer for type 0x" + Integer.toHexString(typeId));
        }
        Object result = this.typeSerializer[typeId].read(bis);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectSerializer
    implements TypeSerializer<Object> {
        @Override
        public final int priority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Serializable;
        }

        @Override
        public final byte getTypeId() {
            return 0;
        }

        @Override
        public final Object read(FastByteArrayInputStream bbis) throws Exception {
            if (gzipEnabled) {
                return this.readGZip(bbis);
            }
            return this.readNormal(bbis);
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            if (gzipEnabled) {
                this.writeGZip(bbos, obj);
            } else {
                this.writeNormal(bbos, obj);
            }
        }

        private Object readGZip(FastByteArrayInputStream bbis) throws Exception {
            BufferedInputStream zis = new BufferedInputStream(new GZIPInputStream(bbis));
            ObjectInputStream in = AbstractSerializer.newObjectInputStream(zis);
            Object result = shared ? in.readObject() : in.readUnshared();
            in.close();
            return result;
        }

        private Object readNormal(FastByteArrayInputStream bbis) throws Exception {
            ObjectInputStream in = AbstractSerializer.newObjectInputStream(bbis);
            Object result = shared ? in.readObject() : in.readUnshared();
            in.close();
            return result;
        }

        private void writeGZip(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            BufferedOutputStream zos = new BufferedOutputStream(new GZIPOutputStream(bbos));
            ObjectOutputStream os = new ObjectOutputStream(zos);
            if (shared) {
                os.writeObject(obj);
            } else {
                os.writeUnshared(obj);
            }
            os.flush();
            os.close();
        }

        private void writeNormal(FastByteArrayOutputStream bbos, Object obj) throws Exception {
            ObjectOutputStream os = new ObjectOutputStream(bbos);
            if (shared) {
                os.writeObject(obj);
            } else {
                os.writeUnshared(obj);
            }
            os.flush();
            os.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Externalizer
    implements TypeSerializer<Externalizable> {
        @Override
        public final int priority() {
            return 50;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Externalizable;
        }

        @Override
        public final byte getTypeId() {
            return 8;
        }

        @Override
        public final Externalizable read(FastByteArrayInputStream bbis) throws Exception {
            String className = bbis.readUTF();
            try {
                Externalizable ds = (Externalizable)AbstractSerializer.newInstance(AbstractSerializer.classForName(className));
                ds.readExternal(AbstractSerializer.newObjectInputStream(bbis));
                return ds;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Problem reading Externalizable class : " + className + ", exception: " + e);
            }
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Externalizable obj) throws Exception {
            bbos.writeUTF(obj.getClass().getName());
            ObjectOutputStream out = new ObjectOutputStream(bbos);
            obj.writeExternal(out);
            out.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteArraySerializer
    implements TypeSerializer<byte[]> {
        @Override
        public final int priority() {
            return 100;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof byte[];
        }

        @Override
        public final byte getTypeId() {
            return 1;
        }

        @Override
        public final byte[] read(FastByteArrayInputStream bbis) throws Exception {
            int size = bbis.readInt();
            byte[] bytes = new byte[size];
            bbis.readFully(bytes);
            return bytes;
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, byte[] obj) throws Exception {
            bbos.writeInt(obj.length);
            bbos.write(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSerializer
    implements TypeSerializer<String> {
        @Override
        public final int priority() {
            return 400;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof String;
        }

        @Override
        public final byte getTypeId() {
            return 5;
        }

        @Override
        public final String read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readUTF();
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, String obj) throws Exception {
            bbos.writeUTF(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSerializer
    implements TypeSerializer<Class> {
        @Override
        public final int priority() {
            return 500;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Class;
        }

        @Override
        public final byte getTypeId() {
            return 4;
        }

        @Override
        public final Class read(FastByteArrayInputStream bbis) throws Exception {
            return this.classForName(bbis.readUTF());
        }

        protected Class classForName(String className) throws ClassNotFoundException {
            return AbstractSerializer.classForName(className);
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Class obj) throws Exception {
            bbos.writeUTF(obj.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerSerializer
    implements TypeSerializer<Integer> {
        @Override
        public final int priority() {
            return 300;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Integer;
        }

        @Override
        public final byte getTypeId() {
            return 2;
        }

        @Override
        public final Integer read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readInt();
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Integer obj) throws Exception {
            bbos.writeInt(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerSerializer
    implements TypeSerializer<BigInteger> {
        @Override
        public final int priority() {
            return 600;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof BigInteger;
        }

        @Override
        public final byte getTypeId() {
            return 7;
        }

        @Override
        public final BigInteger read(FastByteArrayInputStream bbis) throws Exception {
            byte[] bytes = new byte[bbis.readInt()];
            bbis.readFully(bytes);
            return new BigInteger(bytes);
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, BigInteger obj) throws Exception {
            byte[] bytes = obj.toByteArray();
            bbos.writeInt(bytes.length);
            bbos.write(bytes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    implements TypeSerializer<Date> {
        @Override
        public int priority() {
            return 500;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Date;
        }

        @Override
        public final byte getTypeId() {
            return 6;
        }

        @Override
        public final Date read(FastByteArrayInputStream bbis) throws Exception {
            return new Date(bbis.readLong());
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Date obj) throws Exception {
            bbos.writeLong(obj.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSerializer
    implements TypeSerializer<Long> {
        @Override
        public final int priority() {
            return 200;
        }

        @Override
        public final boolean isSuitable(Object obj) {
            return obj instanceof Long;
        }

        @Override
        public final byte getTypeId() {
            return 3;
        }

        @Override
        public final Long read(FastByteArrayInputStream bbis) throws Exception {
            return bbis.readLong();
        }

        @Override
        public final void write(FastByteArrayOutputStream bbos, Long obj) throws Exception {
            bbos.writeLong(obj);
        }
    }
}

