/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.security;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.X509NameTokenizer;

public abstract class BaseCrypto
implements Crypto {
    private static final String SKI_OID = "2.5.29.14";
    private String provider;
    private CertificateFactory certFact;
    private String defaultX509Alias;

    public void setDefaultX509Alias(String defaultX509Alias) {
        this.defaultX509Alias = defaultX509Alias;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getAliasForX509Cert(Certificate cert) throws WSSecurityException {
        try {
            String alias = this.getCertificateAlias(cert);
            if (alias != null) {
                return alias;
            }
            String[] allAliases = this.getAliases();
            for (int i = 0; i < allAliases.length; ++i) {
                Certificate cert2 = this.getCertificate(alias);
                if (!cert2.equals(cert)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getAliasForX509Cert(String issuer) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, null, false);
    }

    public String getAliasForX509Cert(byte[] skiBytes) throws WSSecurityException {
        Certificate cert = null;
        try {
            String[] allAliases = this.getAliases();
            for (int i = 0; i < allAliases.length; ++i) {
                byte[] data;
                String alias = allAliases[i];
                cert = this.getCertificateChainOrCertificate(alias);
                if (!(cert instanceof X509Certificate) || !Arrays.equals(data = this.getSKIBytesFromCert((X509Certificate)cert), skiBytes)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String getAliasForX509Cert(String issuer, BigInteger serialNumber) throws WSSecurityException {
        return this.getAliasForX509Cert(issuer, serialNumber, true);
    }

    public String getAliasForX509CertThumb(byte[] thumb) throws WSSecurityException {
        Certificate cert = null;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e1) {
            throw new WSSecurityException(0, "noSHA1availabe");
        }
        try {
            String[] allAliases = this.getAliases();
            for (int i = 0; i < allAliases.length; ++i) {
                String alias = allAliases[i];
                cert = this.getCertificateChainOrCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                sha.reset();
                try {
                    sha.update(cert.getEncoded());
                }
                catch (CertificateEncodingException e1) {
                    throw new WSSecurityException(7, "encodeError");
                }
                byte[] data = sha.digest();
                if (!Arrays.equals(data, thumb)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    public String[] getAliasesForDN(String subjectDN) throws WSSecurityException {
        Vector<String> aliases = new Vector<String>();
        Certificate cert = null;
        Vector subjectRDN = this.splitAndTrim(subjectDN);
        try {
            String[] allAliases = this.getAliases();
            for (int i = 0; i < allAliases.length; ++i) {
                Vector foundRDN;
                String alias = allAliases[i];
                cert = this.getCertificateChainOrCertificate(alias);
                if (!(cert instanceof X509Certificate) || !subjectRDN.equals(foundRDN = this.splitAndTrim(((X509Certificate)cert).getSubjectDN().getName()))) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        Vector<X509Certificate> list = new Vector<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.insertElementAt(certs[i], 0);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
    }

    public synchronized CertificateFactory getCertificateFactory() throws WSSecurityException {
        if (this.certFact == null) {
            try {
                this.certFact = this.provider == null || this.provider.length() == 0 ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.provider);
            }
            catch (CertificateException e) {
                throw new WSSecurityException(7, "unsupportedCertType");
            }
            catch (NoSuchProviderException e) {
                throw new WSSecurityException(7, "noSecProvider");
            }
        }
        return this.certFact;
    }

    public X509Certificate[] getCertificates(String alias) throws WSSecurityException {
        try {
            Certificate[] certs = this.getCertificateChain(alias);
            if (certs != null && certs.length > 0) {
                ArrayList<Certificate> x509certs = new ArrayList<Certificate>();
                for (int i = 0; i < certs.length; ++i) {
                    if (!(certs[i] instanceof X509Certificate)) continue;
                    x509certs.add(certs[i]);
                }
                return x509certs.toArray(new X509Certificate[x509certs.size()]);
            }
            Certificate cert = this.getCertificate(alias);
            if (cert instanceof X509Certificate) {
                return new X509Certificate[]{(X509Certificate)cert};
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
    }

    public String getDefaultX509Alias() {
        return this.defaultX509Alias;
    }

    public KeyStore getKeyStore() {
        return null;
    }

    public abstract PrivateKey getPrivateKey(String var1, String var2) throws WSSecurityException;

    public byte[] getSKIBytesFromCert(X509Certificate cert) throws WSSecurityException {
        byte[] derEncodedValue = cert.getExtensionValue(SKI_OID);
        if (cert.getVersion() < 3 || derEncodedValue == null) {
            MessageDigest sha;
            PublicKey key = cert.getPublicKey();
            if (!(key instanceof RSAPublicKey)) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Support for RSA key only"});
            }
            byte[] encoded = key.getEncoded();
            byte[] value = new byte[encoded.length - 22];
            System.arraycopy(encoded, 22, value, 0, value.length);
            try {
                sha = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new WSSecurityException(1, "noSKIHandling", new Object[]{"Wrong certificate version (<3) and no SHA1 message digest availabe"});
            }
            sha.reset();
            sha.update(value);
            return sha.digest();
        }
        byte[] abyte0 = new byte[derEncodedValue.length - 4];
        System.arraycopy(derEncodedValue, 4, abyte0, 0, abyte0.length);
        return abyte0;
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertPath path = null;
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    public X509Certificate loadCertificate(InputStream in) throws WSSecurityException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)this.getCertificateFactory().generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        return cert;
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        try {
            List<X509Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            String[] aliases = this.getTrustCertificates();
            for (int i = 0; i < aliases.length; ++i) {
                Certificate cert = this.getCertificate(aliases[i]);
                if (!(cert instanceof X509Certificate)) continue;
                hashSet.add(new TrustAnchor((X509Certificate)cert, null));
            }
            PKIXParameters param = new PKIXParameters(hashSet);
            param.setRevocationEnabled(false);
            CertPathValidator certPathValidator = this.provider == null || this.provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", this.provider);
            certPathValidator.validate(path, param);
        }
        catch (NoSuchProviderException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (CertPathValidatorException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        return true;
    }

    protected Vector splitAndTrim(String inString) {
        X509NameTokenizer nmTokens = new X509NameTokenizer(inString);
        Vector<String> vr = new Vector<String>();
        while (nmTokens.hasMoreTokens()) {
            vr.add(nmTokens.nextToken());
        }
        Collections.sort(vr);
        return vr;
    }

    protected Certificate getCertificateChainOrCertificate(String alias) throws KeyStoreException {
        Certificate[] certs = this.getCertificateChain(alias);
        Certificate cert = null;
        if (certs == null || certs.length == 0) {
            cert = this.getCertificate(alias);
            if (cert == null) {
                return null;
            }
        } else {
            cert = certs[0];
        }
        return cert;
    }

    private String getAliasForX509Cert(String issuer, BigInteger serialNumber, boolean useSerialNumber) throws WSSecurityException {
        Vector issuerRDN = this.splitAndTrim(issuer);
        X509Certificate x509cert = null;
        Vector certRDN = null;
        Certificate cert = null;
        try {
            String[] allAliases = this.getAliases();
            for (int i = 0; i < allAliases.length; ++i) {
                String alias = allAliases[i];
                cert = this.getCertificateChainOrCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                x509cert = (X509Certificate)cert;
                if (useSerialNumber && (!useSerialNumber || x509cert.getSerialNumber().compareTo(serialNumber) != 0) || !(certRDN = this.splitAndTrim(x509cert.getIssuerDN().getName())).equals(issuerRDN)) continue;
                return alias;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException(0, "keystore");
        }
        return null;
    }

    protected abstract String[] getAliases() throws KeyStoreException;

    protected abstract Certificate[] getCertificateChain(String var1) throws KeyStoreException;

    protected abstract Certificate getCertificate(String var1) throws KeyStoreException;

    protected abstract String getCertificateAlias(Certificate var1) throws KeyStoreException;

    protected abstract String[] getTrustCertificates() throws KeyStoreException;
}

