/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import javax.security.auth.callback.CallbackHandler;
import org.apache.servicemix.soap.handlers.security.BaseCrypto;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CryptoType;
import org.springframework.core.io.Resource;

public class StandaloneCrypto
extends BaseCrypto {
    private Resource keyStoreUrl;
    private String keyStoreType;
    private String keyStorePassword;
    private KeyStore keyStore;
    private String keyPassword;

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public Resource getKeyStoreUrl() {
        return this.keyStoreUrl;
    }

    public void setKeyStoreUrl(Resource keyStoreUrl) {
        this.keyStoreUrl = keyStoreUrl;
    }

    protected String[] getAliases() throws KeyStoreException {
        ArrayList<String> aliases = Collections.list(this.loadKeyStore().aliases());
        return aliases.toArray(new String[aliases.size()]);
    }

    protected Certificate getCertificate(String alias) throws KeyStoreException {
        return this.loadKeyStore().getCertificate(alias);
    }

    protected String getCertificateAlias(Certificate cert) throws KeyStoreException {
        return this.loadKeyStore().getCertificateAlias(cert);
    }

    protected Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.loadKeyStore().getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias, String password) throws WSSecurityException {
        password = this.keyPassword;
        if (password == null) {
            password = this.keyStorePassword;
        }
        if (alias == null) {
            throw new WSSecurityException("alias is null");
        }
        KeyStore keystore = null;
        try {
            keystore = this.loadKeyStore();
        }
        catch (Exception e) {
            throw new WSSecurityException("Cannot load key store", (Throwable)e);
        }
        boolean b = false;
        try {
            b = keystore.isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Cannot find key for alias: " + alias, (Throwable)e);
        }
        if (!b) {
            throw new WSSecurityException("Cannot find key for alias: " + alias);
        }
        Key keyTmp = null;
        try {
            keyTmp = keystore.getKey(alias, password == null || password.length() == 0 ? new char[]{} : password.toCharArray());
        }
        catch (Exception e) {
            throw new WSSecurityException("Cannot get private key", (Throwable)e);
        }
        if (!(keyTmp instanceof PrivateKey)) {
            throw new WSSecurityException("Key is not a private key, alias: " + alias);
        }
        return (PrivateKey)keyTmp;
    }

    protected String[] getTrustCertificates() throws KeyStoreException {
        KeyStore keystore = this.loadKeyStore();
        HashSet<String> hashSet = new HashSet<String>();
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keystore.isCertificateEntry(alias)) continue;
            hashSet.add(alias);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public synchronized KeyStore loadKeyStore() throws KeyStoreException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        if (this.keyStoreUrl == null) {
            throw new IllegalArgumentException("keyStoreUrl not specified in this StandaloneCrypto");
        }
        InputStream input = null;
        try {
            input = this.keyStoreUrl.getInputStream();
            String provider = this.getProvider();
            String type = this.keyStoreType != null ? this.keyStoreType : KeyStore.getDefaultType();
            this.keyStore = provider == null || provider.length() == 0 ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            this.keyStore.load(input, this.keyStorePassword == null || this.keyStorePassword.length() == 0 ? new char[]{} : this.keyStorePassword.toCharArray());
            KeyStore keyStore = this.keyStore;
            return keyStore;
        }
        catch (IOException e) {
            throw new KeyStoreException(e);
        }
        catch (GeneralSecurityException e) {
            throw new KeyStoreException(e);
        }
        catch (Exception e) {
            throw new KeyStoreException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    public String getCryptoProvider() {
        return null;
    }

    public void setCryptoProvider(String provider) {
    }

    public String getDefaultX509Identifier() throws WSSecurityException {
        return null;
    }

    public void setDefaultX509Identifier(String identifier) {
    }

    public void setCertificateFactory(String provider, CertificateFactory certFactory) {
    }

    public byte[] getBytesFromCertificates(X509Certificate[] certs) throws WSSecurityException {
        return null;
    }

    public X509Certificate[] getCertificatesFromBytes(byte[] data) throws WSSecurityException {
        return null;
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        return null;
    }

    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        return null;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        return null;
    }

    public boolean verifyTrust(X509Certificate[] certs) throws WSSecurityException {
        return false;
    }

    public boolean verifyTrust(PublicKey publicKey) throws WSSecurityException {
        return false;
    }

    public boolean verifyTrust(X509Certificate[] arg0, boolean arg1) throws WSSecurityException {
        return false;
    }
}

