/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.ehcache;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreListener;
import org.apache.servicemix.store.base.BaseStoreFactory;
import org.apache.servicemix.store.ehcache.CacheManagerFactory;
import org.apache.servicemix.store.ehcache.EhCacheStore;

public class EhCacheStoreFactory
extends BaseStoreFactory {
    private static final Log LOG = LogFactory.getLog(EhCacheStoreFactory.class);
    protected IdGenerator idGenerator = new IdGenerator();
    private Map<String, EhCacheStore> stores = new HashMap<String, EhCacheStore>();
    private CacheManagerFactory cacheManagerFactory = new CacheManagerFactory();
    private CacheManager cacheManager;

    public synchronized Store open(String name) throws IOException {
        EhCacheStore store = this.stores.get(name);
        if (store == null) {
            Cache cache;
            if (this.cacheManager == null) {
                this.cacheManager = this.cacheManagerFactory.build();
            }
            if ((cache = this.cacheManager.getCache(name)) == null) {
                this.cacheManager.addCache(name);
                cache = this.cacheManager.getCache(name);
            }
            store = new EhCacheStore(cache, this.idGenerator, name);
            for (StoreListener listener : this.storeListeners) {
                store.addListener(listener);
            }
            this.stores.put(name, store);
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        EhCacheStore ehCacheStore = (EhCacheStore)store;
        try {
            ehCacheStore.destroy();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.stores.remove(ehCacheStore.getName());
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }
}

