/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import java.util.List;
import krati.core.array.basic.ArrayEntryManager;
import krati.core.array.basic.ArrayFile;
import krati.core.array.basic.RecoverableArray;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryFactory;
import krati.core.array.entry.EntryValue;
import org.apache.log4j.Logger;

abstract class AbstractRecoverableArray<V extends EntryValue>
implements RecoverableArray<V> {
    protected int _length;
    protected File _directory;
    protected ArrayFile _arrayFile;
    protected EntryFactory<V> _entryFactory;
    protected ArrayEntryManager<V> _entryManager;

    protected AbstractRecoverableArray(int length, int elemSize, int entrySize, int maxEntries, File directory, EntryFactory<V> entryFactory) throws Exception {
        this._length = length;
        this._directory = directory;
        this._entryFactory = entryFactory;
        this._entryManager = new ArrayEntryManager(this, maxEntries, entrySize);
        if (!this._directory.exists()) {
            this._directory.mkdirs();
        }
        File file = new File(this._directory, "indexes.dat");
        this._arrayFile = this.openArrayFile(file, length, elemSize);
        this._length = this._arrayFile.getArrayLength();
        this.init();
        this.getLogger().info((Object)("length:" + this._length + " entrySize:" + entrySize + " maxEntries:" + maxEntries + " directory:" + directory.getAbsolutePath() + " arrayFile:" + this._arrayFile.getName()));
    }

    protected void init() throws IOException {
        try {
            long lwmScn = this._arrayFile.getLwmScn();
            long hwmScn = this._arrayFile.getHwmScn();
            if (hwmScn < lwmScn) {
                throw new IOException(this._arrayFile.getAbsolutePath() + " is corrupted: lwmScn=" + lwmScn + " hwmScn=" + hwmScn);
            }
            this._entryManager.init(lwmScn, hwmScn);
            this.loadArrayFileData();
        }
        catch (IOException e) {
            this._entryManager.clear();
            this.getLogger().error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected final ArrayFile openArrayFile(File file, int initialLength, int elementSize) throws IOException {
        boolean isNew = true;
        if (file.exists()) {
            isNew = false;
        }
        ArrayFile arrayFile = new ArrayFile(file, initialLength, elementSize);
        if (isNew) {
            this.initArrayFile();
        }
        return arrayFile;
    }

    protected void initArrayFile() throws IOException {
    }

    protected abstract void loadArrayFileData() throws IOException;

    protected abstract Logger getLogger();

    @Override
    public File getDirectory() {
        return this._directory;
    }

    @Override
    public EntryFactory<V> getEntryFactory() {
        return this._entryFactory;
    }

    public ArrayEntryManager<V> getEntryManager() {
        return this._entryManager;
    }

    @Override
    public boolean hasIndex(int index) {
        return 0 <= index && index < this._length;
    }

    @Override
    public final int length() {
        return this._length;
    }

    @Override
    public void sync() throws IOException {
        this._entryManager.sync();
        this.getLogger().info((Object)("array saved: length=" + this.length()));
    }

    @Override
    public void persist() throws IOException {
        this._entryManager.persist();
        this.getLogger().info((Object)("array persisted: length=" + this.length()));
    }

    @Override
    public final long getHWMark() {
        return this._entryManager.getHWMark();
    }

    @Override
    public final long getLWMark() {
        return this._entryManager.getLWMark();
    }

    @Override
    public void updateArrayFile(List<Entry<V>> entryList) throws IOException {
        if (this._arrayFile != null) {
            this._arrayFile.update(entryList);
        }
    }
}

