/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.basic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import krati.Persistable;
import krati.core.array.basic.RecoverableArray;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryFactory;
import krati.core.array.entry.EntryPersistListener;
import krati.core.array.entry.EntryPool;
import krati.core.array.entry.EntryValue;
import krati.core.array.entry.PreFillEntryInt;
import krati.core.array.entry.PreFillEntryLong;
import krati.core.array.entry.PreFillEntryShort;
import org.apache.log4j.Logger;

public class ArrayEntryManager<V extends EntryValue>
implements Persistable {
    private static final Logger _log = Logger.getLogger(ArrayEntryManager.class);
    private final int _maxEntries;
    private final int _maxEntrySize;
    private volatile boolean _autoApplyEntries = true;
    private volatile long _lwmScn = 0L;
    private volatile long _hwmScn = 0L;
    private RecoverableArray<V> _array;
    private Entry<V> _entry;
    private Entry<V> _entryCompaction;
    private final EntryPool<V> _entryPool;
    private final EntryApply<V> _entryApply;
    private EntryPersistListener _persistListener;

    public ArrayEntryManager(RecoverableArray<V> array, int maxEntries, int maxEntrySize) {
        this._array = array;
        this._maxEntries = maxEntries;
        this._maxEntrySize = maxEntrySize;
        this._entryPool = new EntryPool<V>(array.getEntryFactory(), maxEntrySize);
        this._entryApply = new EntryApply(this);
        this._entry = this._entryPool.next();
        this._entryCompaction = this._entryPool.next();
        _log.info((Object)("arrayLength=" + array.length() + " maxEntries=" + maxEntries + " maxEntrySize=" + maxEntrySize));
    }

    public int getMaxEntries() {
        return this._maxEntries;
    }

    public int getMaxEntrySize() {
        return this._maxEntrySize;
    }

    public File getDirectory() {
        return this._array.getDirectory();
    }

    public EntryFactory<V> getEntryFactory() {
        return this._array.getEntryFactory();
    }

    public boolean getAutoApplyEntries() {
        return this._autoApplyEntries;
    }

    public void setAutoApplyEntries(boolean b) {
        this._autoApplyEntries = b;
    }

    final void addToEntry(V entryValue) throws IOException {
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
        this._entry.add(entryValue);
        this._hwmScn = Math.max(this._hwmScn, ((EntryValue)entryValue).scn);
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
    }

    final void addToEntryCompaction(V entryValue) throws IOException {
        if (this._entryCompaction.isFull()) {
            this.switchEntryCompaction(false);
        }
        this._entryCompaction.add(entryValue);
        if (this._entryCompaction.isFull()) {
            this.switchEntryCompaction(false);
        }
    }

    final void addToPreFillEntryInt(int pos, int val, long scn) throws IOException {
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
        ((PreFillEntryInt)this._entry).add(pos, val, scn);
        this._hwmScn = Math.max(this._hwmScn, scn);
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
    }

    final void addToPreFillEntryLong(int pos, long val, long scn) throws IOException {
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
        ((PreFillEntryLong)this._entry).add(pos, val, scn);
        this._hwmScn = Math.max(this._hwmScn, scn);
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
    }

    final void addToPreFillEntryLongCompaction(int pos, long val, long scn) throws IOException {
        if (this._entryCompaction.isFull()) {
            this.switchEntryCompaction(false);
        }
        ((PreFillEntryLong)this._entryCompaction).add(pos, val, scn);
        if (this._entryCompaction.isFull()) {
            this.switchEntryCompaction(false);
        }
    }

    final void addToPreFillEntryShort(int pos, short val, long scn) throws IOException {
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
        ((PreFillEntryShort)this._entry).add(pos, val, scn);
        this._hwmScn = Math.max(this._hwmScn, scn);
        if (this._entry.isFull()) {
            this.switchEntry(false);
        }
    }

    public synchronized void clear() {
        this._lwmScn = 0L;
        this._hwmScn = 0L;
        this._entry.clear();
        this._entryCompaction.clear();
        this._entryPool.clear();
        try {
            this.deleteEntryFiles();
        }
        catch (IOException e) {
            _log.warn((Object)e.getMessage());
        }
        _log.info((Object)"entry files cleared");
    }

    @Override
    public long getHWMark() {
        return this._hwmScn;
    }

    @Override
    public long getLWMark() {
        return this._lwmScn;
    }

    @Override
    public void saveHWMark(long endOfPeriod) throws Exception {
        this._hwmScn = Math.max(this._hwmScn, endOfPeriod);
    }

    public void setWaterMarks(long lwmScn, long hwmScn) {
        if (lwmScn <= hwmScn) {
            this._lwmScn = lwmScn;
            this._hwmScn = hwmScn;
        }
    }

    @Override
    public void sync() throws IOException {
        this.switchEntry(true);
        this.applyEntries(true);
    }

    @Override
    public void persist() throws IOException {
        this.switchEntry(false);
    }

    public void setEntryPersistListener(EntryPersistListener listener) {
        this._persistListener = listener;
    }

    public EntryPersistListener getEntryPersistListener() {
        return this._persistListener;
    }

    protected final String getEntryLogName(Entry<V> entry) {
        return this.getEntryLogPrefix() + "_" + entry.getServiceId() + "_" + entry.getMinScn() + "_" + entry.getMaxScn() + this.getEntryLogSuffix();
    }

    protected final String getEntryLogPrefix() {
        return "entry";
    }

    protected final String getEntryLogSuffix() {
        return ".idx";
    }

    protected synchronized void switchEntry(boolean blocking) throws IOException {
        File file;
        if (!this._entry.isEmpty()) {
            if (this._persistListener != null) {
                this._persistListener.beforePersist(this._entry);
            }
            file = new File(this.getDirectory(), this.getEntryLogName(this._entry));
            this._entry.save(file);
            if (this._persistListener != null) {
                this._persistListener.afterPersist(this._entry);
            }
            this._lwmScn = Math.max(this._lwmScn, this._entry.getMaxScn());
            this._entryPool.addToServiceQueue(this._entry);
            this._entry = this._entryPool.next();
            _log.info((Object)("switchEntry to " + this._entry.getId() + " _lwmScn=" + this._lwmScn + " _hwmScn=" + this._hwmScn));
        }
        if (!this._entryCompaction.isEmpty()) {
            file = new File(this.getDirectory(), this.getEntryLogName(this._entryCompaction));
            this._entryCompaction.save(file);
            this._entryPool.addToServiceQueue(this._entryCompaction);
            this._entryCompaction = this._entryPool.next();
            _log.info((Object)("switchEntry to " + this._entryCompaction.getId() + " _lwmScn=" + this._lwmScn + " _hwmScn=" + this._hwmScn + " Compaction"));
        }
        if (this._autoApplyEntries && this._entryPool.getServiceQueueSize() >= this._maxEntries) {
            this.applyEntries(blocking);
        }
    }

    private synchronized void switchEntryCompaction(boolean blocking) throws IOException {
        if (!this._entryCompaction.isEmpty()) {
            File file = new File(this.getDirectory(), this.getEntryLogName(this._entryCompaction));
            this._entryCompaction.save(file);
            this._entryPool.addToServiceQueue(this._entryCompaction);
            this._entryCompaction = this._entryPool.next();
            _log.info((Object)("switchEntry to " + this._entryCompaction.getId() + " _lwmScn=" + this._lwmScn + " _hwmScn=" + this._hwmScn + " Compaction"));
        }
        if (this._autoApplyEntries && this._entryPool.getServiceQueueSize() >= this._maxEntries) {
            this.applyEntries(blocking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void applyEntries(boolean blocking) throws IOException {
        if (blocking) {
            EntryApply<V> entryApply = this._entryApply;
            synchronized (entryApply) {
                ArrayList<Entry<V>> entryList = new ArrayList<Entry<V>>();
                while (this._entryPool.getServiceQueueSize() > 0) {
                    Entry<V> entry = this._entryPool.pollFromService();
                    if (entry == null) continue;
                    entryList.add(entry);
                }
                this.applyEntries(entryList);
            }
        }
        EntryApply<V> entryApply = this._entryApply;
        synchronized (entryApply) {
            for (int i = 0; i < this._maxEntries; ++i) {
                Entry<V> entry = this._entryPool.pollFromService();
                if (entry == null) continue;
                this._entryApply.add(entry);
            }
        }
        new Thread(this._entryApply).start();
    }

    protected List<Entry<V>> loadEntryFiles() {
        File[] files = this.getDirectory().listFiles();
        String prefix = this.getEntryLogPrefix();
        String suffix = this.getEntryLogSuffix();
        ArrayList<Entry<V>> entryList = new ArrayList<Entry<V>>();
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.startsWith(prefix) || !fileName.endsWith(suffix)) continue;
            try {
                Entry<V> entry = this._entryPool.next();
                entry.load(file);
                entryList.add(entry);
            }
            catch (IOException e) {
                String filePath = file.getAbsolutePath();
                _log.warn((Object)(filePath + " corrupted"));
                if (!file.delete()) continue;
                _log.warn((Object)(filePath + " deleted"));
            }
        }
        return entryList;
    }

    protected void deleteEntryFiles() throws IOException {
        File[] files = this.getDirectory().listFiles();
        String prefix = this.getEntryLogPrefix();
        String suffix = this.getEntryLogSuffix();
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.startsWith(prefix) || !fileName.endsWith(suffix)) continue;
            if (file.delete()) {
                _log.info((Object)("file " + file.getAbsolutePath() + " deleted"));
                continue;
            }
            _log.warn((Object)("file " + file.getAbsolutePath() + " not deleted"));
        }
    }

    private void deleteEntryFiles(List<Entry<V>> list) throws IOException {
        for (Entry<V> e : list) {
            File file = e.getFile();
            if (file == null || !file.exists()) continue;
            if (file.delete()) {
                _log.info((Object)(file.getName() + " deleted"));
                continue;
            }
            _log.warn((Object)(file.getName() + " not deleted"));
        }
    }

    private List<Entry<V>> filterEntryList(List<Entry<V>> entryList, long minScn, long maxScn) {
        ArrayList<Entry<V>> result = new ArrayList<Entry<V>>(entryList.size());
        for (Entry<V> e : entryList) {
            if (minScn > e.getMinScn() || e.getMaxScn() > maxScn) continue;
            result.add(e);
        }
        return result;
    }

    private List<Entry<V>> filterEntryListLowerBound(List<Entry<V>> entryList, long scn) {
        ArrayList<Entry<V>> result = new ArrayList<Entry<V>>(entryList.size());
        for (Entry<V> e : entryList) {
            if (scn > e.getMinScn()) continue;
            result.add(e);
        }
        return result;
    }

    private List<Entry<V>> filterEntryListUpperBound(List<Entry<V>> entryList, long scn) {
        ArrayList<Entry<V>> result = new ArrayList<Entry<V>>(entryList.size());
        for (Entry<V> e : entryList) {
            if (e.getMaxScn() > scn) continue;
            result.add(e);
        }
        return result;
    }

    protected void applyEntries(List<Entry<V>> entries) throws IOException {
        this._array.updateArrayFile(entries);
        this.deleteEntryFiles(entries);
        for (Entry<V> entry : entries) {
            this._entryPool.addToRecycleQueue(entry);
        }
        entries.clear();
    }

    protected void init(long arrayFileLwmScn, long arrayFileHwmScn) throws IOException {
        List<Entry<V>> entryList = this.loadEntryFiles();
        if (arrayFileLwmScn == arrayFileHwmScn) {
            if (entryList.size() > 0) {
                entryList = this.filterEntryListLowerBound(entryList, arrayFileLwmScn);
            }
        } else if (entryList.size() > 0 && (entryList = this.filterEntryList(entryList, arrayFileLwmScn, arrayFileHwmScn)).size() == 0) {
            this.deleteEntryFiles();
            _log.error((Object)"entry files for recovery not found");
        }
        if (entryList.size() > 0) {
            this.applyEntries(entryList);
        }
        this.deleteEntryFiles();
    }

    static class EntryApply<V extends EntryValue>
    implements Runnable {
        private final List<Entry<V>> _entryList;
        private final ArrayEntryManager<V> _entryManager;

        public EntryApply(ArrayEntryManager<V> entryManager) {
            this._entryManager = entryManager;
            this._entryList = new ArrayList<Entry<V>>();
        }

        public final void add(Entry<V> entry) {
            this._entryList.add(entry);
        }

        @Override
        public final synchronized void run() {
            try {
                this._entryManager.applyEntries(this._entryList);
            }
            catch (IOException ioe) {
                _log.error((Object)ioe.getMessage());
            }
        }
    }
}

