/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.File;
import java.io.IOException;
import krati.core.array.entry.Entry;
import krati.core.array.entry.EntryValue;
import krati.core.array.entry.EntryValueFactory;
import krati.io.ChannelReader;
import krati.io.DataReader;
import krati.io.DataWriter;
import krati.io.FastDataWriter;
import krati.util.Chronos;
import org.apache.log4j.Logger;

public abstract class AbstractEntry<T extends EntryValue>
implements Entry<T> {
    private static final Logger _log = Logger.getLogger(Entry.class);
    protected long _minScn = 0L;
    protected long _maxScn = 0L;
    protected final int _entryId;
    protected final EntryValueFactory<T> _valFactory;
    protected int _entryCapacity;
    private int _entryServiceId = 0;
    private File _entryFile = null;

    protected AbstractEntry(int entryId, EntryValueFactory<T> valFactory, int initialCapacity) {
        this._entryId = entryId;
        this._valFactory = valFactory;
        this._entryCapacity = initialCapacity;
    }

    @Override
    public final int getId() {
        return this._entryId;
    }

    @Override
    public final int getServiceId() {
        return this._entryServiceId;
    }

    @Override
    public final void setServiceId(int serviceId) {
        this._entryServiceId = serviceId;
    }

    @Override
    public File getFile() {
        return this._entryFile;
    }

    @Override
    public final long getMinScn() {
        return this._minScn;
    }

    @Override
    public final long getMaxScn() {
        return this._maxScn;
    }

    @Override
    public final EntryValueFactory<T> getValueFactory() {
        return this._valFactory;
    }

    @Override
    public final int capacity() {
        return this._entryCapacity;
    }

    @Override
    public final boolean isFull() {
        return this.size() >= this._entryCapacity;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this._minScn = 0L;
        this._maxScn = 0L;
    }

    @Override
    public int compareTo(Entry<T> e) {
        return this._maxScn < e.getMaxScn() ? -1 : (this._maxScn == e.getMaxScn() ? (this._minScn < e.getMinScn() ? -1 : (this._minScn == e.getMinScn() ? 0 : 1)) : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(File file) throws IOException {
        this._entryFile = file;
        Chronos c = new Chronos();
        FastDataWriter out = new FastDataWriter(file);
        try {
            out.open();
            out.writeLong(0L);
            out.writeLong(this._minScn);
            out.writeLong(this._maxScn);
            out.writeInt(this.size());
            this.saveDataSection(out);
            out.writeLong(this._minScn);
            out.writeLong(this._maxScn);
        }
        finally {
            out.close();
        }
        _log.info((Object)("Saved entry: minScn=" + this._minScn + " maxScn=" + this._maxScn + " size=" + this.size() + " file=" + file.getName() + " in " + c.getElapsedTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(File file) throws IOException {
        this._entryFile = file;
        Chronos c = new Chronos();
        ChannelReader in = new ChannelReader(file);
        try {
            in.open();
            long fileVersion = in.readLong();
            if (fileVersion != 0L) {
                throw new RuntimeException("Wrong storage version " + fileVersion + " encounted in " + file.getAbsolutePath() + ". Version " + 0L + " expected.");
            }
            long minScnHead = in.readLong();
            long maxScnHead = in.readLong();
            int length = in.readInt();
            this.loadDataSection(in, length);
            long minScnTail = in.readLong();
            long maxScnTail = in.readLong();
            if (minScnHead != minScnTail) {
                throw new IOException("min scns don't match: " + minScnHead + " vs " + minScnTail);
            }
            if (maxScnHead != maxScnTail) {
                throw new IOException("max scns don't match:" + maxScnHead + " vs " + maxScnTail);
            }
            this._minScn = minScnHead;
            this._maxScn = maxScnHead;
            _log.info((Object)("loaded entry: minScn=" + this._minScn + " maxScn=" + this._maxScn + " size=" + this.size() + " file=" + file.getName() + " in " + c.getElapsedTime()));
        }
        finally {
            in.close();
        }
    }

    protected abstract void saveDataSection(DataWriter var1) throws IOException;

    protected abstract void loadDataSection(DataReader var1, int var2) throws IOException;

    protected final void maintainScn(long scn) {
        this._maxScn = Math.max(this._maxScn, scn);
        this._minScn = this._minScn == 0L ? scn : Math.min(this._minScn, scn);
    }
}

