/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class EntryValueBatch {
    protected final int _valueSize;
    protected final int _valueCapacity;
    protected final ByteBuffer _buffer;

    protected EntryValueBatch(int valueSize, int valueCapacity) {
        this._valueSize = valueSize;
        this._valueCapacity = valueCapacity;
        this._buffer = ByteBuffer.allocate(this._valueCapacity * this._valueSize);
    }

    public int getCapacity() {
        return this._valueCapacity;
    }

    public int getByteCapacity() {
        return this._buffer.capacity();
    }

    public ByteBuffer getInternalBuffer() {
        return this._buffer;
    }

    public void write(FileChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(this._buffer.array(), 0, this._buffer.position()));
    }

    public void clear() {
        this._buffer.clear();
    }
}

