/*
 * Decompiled with CFR 0.152.
 */
package krati.core.array.entry;

import java.io.IOException;
import krati.core.array.entry.EntryValue;
import krati.io.DataWriter;

public class EntryValueInt
extends EntryValue {
    public int val;

    public EntryValueInt(int pos, int val, long scn) {
        super(pos, scn);
        this.val = val;
    }

    public final void reinit(int pos, int val, long scn) {
        this.pos = pos;
        this.val = val;
        this.scn = scn;
    }

    public final int getValue() {
        return this.val;
    }

    @Override
    public String toString() {
        return this.pos + ":" + this.val + ":" + this.scn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof EntryValueInt) {
            EntryValueInt v = (EntryValueInt)o;
            return this.pos == v.pos && this.val == v.val && this.scn == v.scn;
        }
        return false;
    }

    public int hashCode() {
        int result = this.pos / 29 + this.val / 113;
        result = 19 * result + (int)(this.scn ^ this.scn >>> 32);
        return result;
    }

    @Override
    public void write(DataWriter writer) throws IOException {
        writer.writeInt(this.pos);
        writer.writeInt(this.val);
        writer.writeLong(this.scn);
    }

    @Override
    public void updateArrayFile(DataWriter writer, long position) throws IOException {
        writer.writeInt(position, this.val);
    }
}

