/*
 * Decompiled with CFR 0.152.
 */
package krati.core.segment;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import krati.core.segment.Segment;
import krati.core.segment.SegmentFactory;
import krati.core.segment.WriteBufferSegment;

public class WriteBufferSegmentFactory
implements SegmentFactory {
    private final ConcurrentLinkedQueue<ByteBuffer> _bufferQueue = new ConcurrentLinkedQueue();

    public WriteBufferSegmentFactory() {
    }

    public WriteBufferSegmentFactory(int segmentFileSizeMB) {
        if (segmentFileSizeMB < 8 || segmentFileSizeMB > 2048) {
            throw new IllegalArgumentException("Invalid argument: " + segmentFileSizeMB);
        }
        int bufferLength = segmentFileSizeMB < 2048 ? segmentFileSizeMB * 1024 * 1024 : Integer.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            ByteBuffer buffer = ByteBuffer.wrap(new byte[bufferLength]);
            this._bufferQueue.add(buffer);
        }
    }

    @Override
    public Segment createSegment(int segmentId, File segmentFile, int initialSizeMB, Segment.Mode mode) throws IOException {
        return new WriteBufferSegment(segmentId, segmentFile, initialSizeMB, mode, this._bufferQueue);
    }
}

