/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import krati.io.BasicIO;
import krati.io.DataWriter;

public class ChannelWriter
implements DataWriter,
BasicIO {
    private final File _file;
    private FileChannel _channel;
    private RandomAccessFile _raf;
    private final ByteBuffer _bbInt = ByteBuffer.wrap(new byte[4]);
    private final ByteBuffer _bbLong = ByteBuffer.wrap(new byte[8]);
    private final ByteBuffer _bbShort = ByteBuffer.wrap(new byte[2]);

    public ChannelWriter(File file) {
        this._file = file;
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void open() throws IOException {
        if (!this._file.exists()) {
            File dir = this._file.getParentFile();
            if (dir.exists()) {
                this._file.createNewFile();
            } else if (dir.mkdirs()) {
                this._file.createNewFile();
            } else {
                throw new IOException("Failed to create file " + this._file.getAbsolutePath());
            }
        }
        if (this._file.isDirectory()) {
            throw new IOException("Cannot open directory " + this._file.getAbsolutePath());
        }
        this._raf = new RandomAccessFile(this._file, "rw");
        this._channel = this._raf.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this._channel.force(true);
            this._channel.close();
            this._raf.close();
        }
        finally {
            this._channel = null;
            this._raf = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this._channel.force(true);
    }

    @Override
    public void force() throws IOException {
        this._channel.force(true);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this._bbInt.position(0);
        this._bbInt.putInt(value);
        this._bbInt.flip();
        this._channel.write(this._bbInt);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this._bbLong.position(0);
        this._bbLong.putLong(value);
        this._bbLong.flip();
        this._channel.write(this._bbLong);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this._bbShort.position(0);
        this._bbShort.putShort(value);
        this._bbShort.flip();
        this._channel.write(this._bbShort);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this._channel.write(ByteBuffer.wrap(bytes));
    }

    @Override
    public void writeInt(long position, int value) throws IOException {
        this._bbInt.position(0);
        this._bbInt.putInt(value);
        this._bbInt.flip();
        this._channel.write(this._bbInt, position);
    }

    @Override
    public void writeLong(long position, long value) throws IOException {
        this._bbLong.position(0);
        this._bbLong.putLong(value);
        this._bbLong.flip();
        this._channel.write(this._bbLong, position);
    }

    @Override
    public void writeShort(long position, short value) throws IOException {
        this._bbShort.position(0);
        this._bbShort.putShort(value);
        this._bbShort.flip();
        this._channel.write(this._bbShort, position);
    }

    public void writeBytes(long position, byte[] bytes) throws IOException {
        this._channel.write(ByteBuffer.wrap(bytes), position);
    }

    @Override
    public long position() throws IOException {
        return this._channel.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this._channel.position(newPosition);
    }

    @Override
    public int readInt(long position) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(4);
        this._channel.read(bb, position);
        bb.flip();
        return bb.getInt();
    }

    @Override
    public long readLong(long position) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8);
        this._channel.read(bb, position);
        bb.flip();
        return bb.getLong();
    }

    @Override
    public short readShort(long position) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(2);
        this._channel.read(bb, position);
        bb.flip();
        return bb.getShort();
    }
}

