/*
 * Decompiled with CFR 0.152.
 */
package krati.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import krati.io.DataWriter;

public class FastDataWriter
implements DataWriter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int MAX_WRITE_ITERATIONS = 10;
    private File _file;
    private final ByteBuffer _buffer;
    private WritableByteChannel _channel;
    static final UnsupportedOperationException _unsupportedOpEx = new UnsupportedOperationException();

    public FastDataWriter(File file) {
        this(file, 8192);
    }

    public FastDataWriter(File file, int bufferSize) {
        if (bufferSize < 512) {
            throw new IllegalArgumentException("bufferSize is too small: at least 512");
        }
        this._file = file;
        this._buffer = ByteBuffer.allocate(bufferSize);
    }

    public void write(int b) throws IOException {
        this.ensureAvailability(1);
        this._buffer.put((byte)b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int remaining = this._buffer.remaining();
        if (remaining >= len) {
            this._buffer.put(b, off, len);
        } else {
            if (remaining > 0) {
                this._buffer.put(b, off, remaining);
                off += remaining;
                len -= remaining;
            }
            this.writeFullBuffer();
            if (len < this._buffer.capacity()) {
                this._buffer.put(b, off, len);
            } else {
                this.writeFullBuffer(ByteBuffer.wrap(b, off, len));
            }
        }
    }

    public void writeByte(int v) throws IOException {
        this.ensureAvailability(1);
        this._buffer.put((byte)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureAvailability(4);
        this._buffer.putInt(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.ensureAvailability(2);
        this._buffer.putShort(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureAvailability(8);
        this._buffer.putLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.ensureAvailability(4);
        this._buffer.putFloat(v);
    }

    public void writeDouble(double v) throws IOException {
        this.ensureAvailability(8);
        this._buffer.putDouble(v);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.ensureAvailability(1);
        this._buffer.put((byte)(v ? 1 : 0));
    }

    @Override
    public File getFile() {
        return this._file;
    }

    @Override
    public void open() throws IOException {
        FileOutputStream out = new FileOutputStream(this._file);
        this._channel = Channels.newChannel(out);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this._channel.close();
    }

    @Override
    public void flush() throws IOException {
        this.writeFullBuffer();
    }

    @Override
    public void force() throws IOException {
        this.writeFullBuffer();
    }

    private void writeFullBuffer() throws IOException {
        this._buffer.flip();
        this.writeFullBuffer(this._buffer);
        this._buffer.clear();
    }

    private void writeFullBuffer(ByteBuffer buffer) throws IOException {
        int iterationsCount = 10;
        while (buffer.remaining() > 0 && iterationsCount > 0) {
            int writeCount = this._channel.write(buffer);
            if (writeCount == 0) {
                --iterationsCount;
                continue;
            }
            iterationsCount = 10;
        }
        if (buffer.remaining() > 0) {
            throw new IOException("couldn't write the buffer after 10 tries");
        }
    }

    private void ensureAvailability(int size) throws IOException {
        if (this._buffer.remaining() < size) {
            this.writeFullBuffer();
        }
    }

    @Override
    public void writeInt(long position, int value) throws IOException {
        throw _unsupportedOpEx;
    }

    @Override
    public void writeLong(long position, long value) throws IOException {
        throw _unsupportedOpEx;
    }

    @Override
    public void writeShort(long position, short value) throws IOException {
        throw _unsupportedOpEx;
    }

    @Override
    public long position() throws IOException {
        throw _unsupportedOpEx;
    }

    @Override
    public void position(long newPosition) throws IOException {
        throw _unsupportedOpEx;
    }
}

