/*
 * Decompiled with CFR 0.152.
 */
package krati.sos;

import java.io.IOException;
import krati.array.Array;
import krati.sos.ObjectHandler;
import krati.sos.ObjectPartition;

public class ObjectPartitionAgent<T>
implements ObjectPartition<T> {
    protected ObjectPartition<T> _partition;
    protected ObjectHandler<T> _inboundHandler;
    protected ObjectHandler<T> _outboundHandler;

    public ObjectPartitionAgent(ObjectPartition<T> partition, ObjectHandler<T> inboundHandler, ObjectHandler<T> outboundHandler) {
        this._partition = partition;
        this._inboundHandler = inboundHandler;
        this._outboundHandler = outboundHandler;
    }

    public ObjectPartition<T> getObjectPartition() {
        return this._partition;
    }

    public ObjectHandler<T> getInboundHandler() {
        return this._inboundHandler;
    }

    public ObjectHandler<T> getOutboundHandler() {
        return this._outboundHandler;
    }

    @Override
    public int getObjectIdCount() {
        return this._partition.getObjectIdCount();
    }

    @Override
    public int getObjectIdStart() {
        return this._partition.getObjectIdStart();
    }

    @Override
    public boolean delete(int objectId, long scn) throws Exception {
        return this._partition.delete(objectId, scn);
    }

    @Override
    public boolean set(int objectId, T object, long scn) throws Exception {
        if (object != null && this._inboundHandler != null && this._inboundHandler.getEnabled()) {
            this._inboundHandler.process(object);
        }
        return this._partition.set(objectId, object, scn);
    }

    @Override
    public T get(int objectId) {
        Object object = this._partition.get(objectId);
        if (object != null && this._outboundHandler != null && this._outboundHandler.getEnabled()) {
            this._outboundHandler.process(object);
        }
        return object;
    }

    @Override
    public void sync() throws IOException {
        this._partition.sync();
    }

    @Override
    public void persist() throws IOException {
        this._partition.persist();
    }

    @Override
    public void clear() {
        this._partition.clear();
    }

    @Override
    public long getHWMark() {
        return this._partition.getHWMark();
    }

    @Override
    public long getLWMark() {
        return this._partition.getLWMark();
    }

    @Override
    public void saveHWMark(long endOfPeriod) throws Exception {
        this._partition.saveHWMark(endOfPeriod);
    }

    @Override
    public byte[] getBytes(int objectId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void expandCapacity(int index) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIndex(int index) {
        return this._partition.hasIndex(index);
    }

    @Override
    public int length() {
        return this._partition.getObjectIdCount();
    }

    @Override
    public boolean isOpen() {
        return this._partition.isOpen();
    }

    @Override
    public void open() throws IOException {
        this._partition.open();
    }

    @Override
    public void close() throws IOException {
        this._partition.close();
    }

    @Override
    public final Array.Type getType() {
        return this._partition.getType();
    }
}

