/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import krati.Mode;
import krati.Persistable;
import krati.core.StoreConfig;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentManager;
import krati.io.Closeable;
import krati.util.DaemonThreadFactory;
import org.apache.log4j.Logger;

public final class BytesDB
implements Persistable,
Closeable {
    static final Logger _logger = Logger.getLogger(BytesDB.class);
    private final SimpleDataArray _dataArray;
    private final AddressArray _addrArray;
    private final StoreConfig _config;
    private volatile Mode _mode = Mode.INIT;
    private volatile int _nextIndexCount = 0;
    private final int _nextIndexQueueCapacity = 10000;
    private final NextIndexLookup _nextIndexLookup = new NextIndexLookup();
    private final LinkedBlockingQueue<Integer> _nextIndexQueue = new LinkedBlockingQueue(10000);
    private ExecutorService _nextIndexExecutor = null;

    public BytesDB(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._addrArray = this.createAddressArray(this._config.getInitialCapacity(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.isIndexesCached());
        String segmentHomePath = new File(this._config.getHomeDir(), "segs").getAbsolutePath();
        SegmentManager segManager = SegmentManager.getInstance(segmentHomePath, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(this._addrArray, segManager, this._config.getSegmentCompactFactor());
        this.initNextIndexCount();
        this._nextIndexLookup.setEnabled(true);
        this._nextIndexExecutor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
        this._nextIndexExecutor.execute(this._nextIndexLookup);
        this._mode = Mode.OPEN;
        _logger.info((Object)("mode=" + (Object)((Object)this._mode)));
    }

    private AddressArray createAddressArray(int length, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createDynamicAddressArray(this.getHomeDir(), batchSize, numSyncBatches);
        addrArray.expandCapacity(length - 1);
        return addrArray;
    }

    public final File getHomeDir() {
        return this._config.getHomeDir();
    }

    public final int capacity() {
        return this._addrArray.length();
    }

    public boolean hasData(int index) {
        return this._dataArray.hasData(index);
    }

    public boolean hasIndex(int index) {
        return this._dataArray.hasIndex(index);
    }

    public int getLength(int index) {
        return this._dataArray.getLength(index);
    }

    public byte[] get(int index) {
        return this._dataArray.get(index);
    }

    public int get(int index, byte[] data) {
        return this._dataArray.get(index, data);
    }

    public int get(int index, byte[] data, int offset) {
        return this._dataArray.get(index, data, offset);
    }

    public synchronized void set(int index, byte[] data, long scn) throws Exception {
        this._dataArray.set(index, data, scn);
        if (data == null) {
            ++this._nextIndexCount;
        }
    }

    public synchronized void set(int index, byte[] data, int offset, int length, long scn) throws Exception {
        this._dataArray.set(index, data, offset, length, scn);
        if (data == null) {
            ++this._nextIndexCount;
        }
    }

    public synchronized int add(byte[] data, long scn) throws Exception {
        int index = this._nextIndexQueue.take();
        this._dataArray.set(index, data, scn);
        --this._nextIndexCount;
        return index;
    }

    public synchronized int add(byte[] data, int offset, int length, long scn) throws Exception {
        int index = this._nextIndexQueue.take();
        this._dataArray.set(index, data, offset, length, scn);
        --this._nextIndexCount;
        return index;
    }

    @Override
    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public final synchronized void saveHWMark(long endOfPeriod) throws Exception {
        this._dataArray.saveHWMark(endOfPeriod);
    }

    @Override
    public final long getHWMark() {
        return this._dataArray.getHWMark();
    }

    @Override
    public final long getLWMark() {
        return this._dataArray.getLWMark();
    }

    private void initNextIndexCount() {
        int length = this._addrArray.length();
        for (int index = 0; index < length; ++index) {
            long addr = this._addrArray.get(index);
            if (addr >= 128L) continue;
            ++this._nextIndexCount;
        }
        _logger.info((Object)("load " + (length - this._nextIndexCount) + "/" + length));
    }

    public synchronized void clear() {
        if (this.isOpen()) {
            this._dataArray.clear();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._mode == Mode.CLOSED) {
            return;
        }
        try {
            this._dataArray.sync();
            this._dataArray.close();
            if (this._nextIndexExecutor != null && !this._nextIndexExecutor.isShutdown()) {
                this._nextIndexLookup.setEnabled(false);
                this._nextIndexExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                this._nextIndexExecutor.shutdown();
            }
        }
        catch (Exception e) {
            throw e instanceof IOException ? (IOException)e : new IOException("Failed to close", e);
        }
        finally {
            this._mode = Mode.CLOSED;
            this._nextIndexCount = 0;
            this._nextIndexQueue.clear();
            this._nextIndexLookup.setEnabled(false);
            _logger.info((Object)("mode=" + (Object)((Object)this._mode)));
        }
    }

    @Override
    public synchronized void open() throws IOException {
        if (this._mode == Mode.OPEN) {
            return;
        }
        try {
            this._dataArray.open();
            this.initNextIndexCount();
            this._nextIndexLookup.setEnabled(true);
            this._nextIndexExecutor = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
            this._nextIndexExecutor.execute(this._nextIndexLookup);
            this._mode = Mode.OPEN;
        }
        catch (Exception e) {
            this._mode = Mode.CLOSED;
            this._nextIndexCount = 0;
            this._nextIndexQueue.clear();
            this._nextIndexLookup.setEnabled(false);
            if (this._dataArray.isOpen()) {
                this._dataArray.close();
            }
            if (this._nextIndexExecutor != null && !this._nextIndexExecutor.isShutdown()) {
                this._nextIndexExecutor.shutdown();
            }
            throw e instanceof IOException ? (IOException)e : new IOException("Failed to close", e);
        }
        finally {
            _logger.info((Object)("mode=" + (Object)((Object)this._mode)));
        }
    }

    @Override
    public final boolean isOpen() {
        return this._mode == Mode.OPEN;
    }

    class NextIndexLookup
    implements Runnable {
        volatile boolean _enabled = true;

        NextIndexLookup() {
        }

        @Override
        public void run() {
            int index = 0;
            int lastPut = -1;
            while (this._enabled) {
                if (index < BytesDB.this._addrArray.length()) {
                    long addr = BytesDB.this._addrArray.get(index);
                    if (addr < 128L) {
                        try {
                            BytesDB.this._nextIndexQueue.put(index);
                            lastPut = index;
                        }
                        catch (InterruptedException e) {
                            _logger.warn((Object)"Failed to add to _nextIndexQueue", (Throwable)e);
                        }
                    }
                    ++index;
                    continue;
                }
                int threshold = (int)((double)BytesDB.this._addrArray.length() * 0.1);
                if (BytesDB.this._nextIndexCount < threshold) {
                    try {
                        BytesDB.this._addrArray.expandCapacity(BytesDB.this._addrArray.length());
                        int cnt = BytesDB.this._nextIndexQueue.remainingCapacity();
                        for (int i = 0; i < cnt; ++i) {
                            if (index >= BytesDB.this._addrArray.length()) continue;
                            long addr = BytesDB.this._addrArray.get(index);
                            if (addr < 128L) {
                                try {
                                    BytesDB.this._nextIndexQueue.put(index);
                                    lastPut = index;
                                }
                                catch (InterruptedException e) {
                                    _logger.warn((Object)"Failed to add to _nextIndexQueue", (Throwable)e);
                                }
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        _logger.error((Object)"failed to expand _addrArray", (Throwable)e);
                    }
                }
                int nextPossible = 0;
                while (!BytesDB.this._nextIndexQueue.isEmpty()) {
                    if (nextPossible >= BytesDB.this._addrArray.length()) continue;
                    long addr = BytesDB.this._addrArray.get(nextPossible);
                    if (addr < 128L) {
                        try {
                            Thread.sleep(0L, 100);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    ++nextPossible;
                }
                if (nextPossible == lastPut) {
                    // empty if block
                }
                index = ++nextPossible;
            }
        }

        public void setEnabled(boolean b) {
            this._enabled = b;
        }

        public boolean isEnabled() {
            return this._enabled;
        }
    }
}

