/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import krati.Mode;
import krati.array.DataArray;
import krati.core.StoreConfig;
import krati.core.StoreParams;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.array.SimpleDataArray;
import krati.core.segment.SegmentFactory;
import krati.core.segment.SegmentManager;
import krati.store.DataSet;
import krati.store.DataSetHandler;
import krati.store.DefaultDataSetHandler;
import krati.store.StoreClosedException;
import krati.util.FnvHashFunction;
import krati.util.HashFunction;
import krati.util.LinearHashing;
import org.apache.log4j.Logger;

public class DynamicDataSet
implements DataSet<byte[]> {
    private static final Logger _log = Logger.getLogger(DynamicDataSet.class);
    private final File _homeDir;
    private final StoreConfig _config;
    private final AddressArray _addrArray;
    private final SimpleDataArray _dataArray;
    private final DataSetHandler _dataHandler;
    private final HashFunction<byte[]> _hashFunction;
    private final double _loadThreshold;
    private final int _unitCapacity;
    private final int _maxLevel;
    private volatile int _split;
    private volatile int _level;
    private volatile int _levelCapacity;
    private volatile int _loadCount;
    private volatile int _loadCountThreshold;

    public DynamicDataSet(StoreConfig config) throws Exception {
        config.validate();
        config.save();
        this._config = config;
        this._homeDir = config.getHomeDir();
        this._dataHandler = new DefaultDataSetHandler();
        this._addrArray = this.createAddressArray(this._config.getHomeDir(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        this._unitCapacity = 65536;
        LinearHashing h = new LinearHashing(this._unitCapacity);
        h.reinit(Integer.MAX_VALUE);
        this._maxLevel = h.getLevel();
        int initLevel = StoreParams.getDynamicStoreInitialLevel(this._config.getInitialCapacity());
        if (initLevel > this._maxLevel) {
            _log.warn((Object)("initLevel reset from " + initLevel + " to " + this._maxLevel));
            initLevel = this._maxLevel;
        }
        this._addrArray.expandCapacity((this._unitCapacity << initLevel) - 1);
        String segmentHome = this._homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(this._addrArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = this._config.getHashFunction();
        this._loadThreshold = this._config.getHashLoadFactor();
        this._loadCount = this.scan();
        this.initLinearHashing();
        _log.info((Object)this.getStatus());
    }

    public DynamicDataSet(File homeDir, int initLevel, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, 10000, 5, 256, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataSet(File homeDir, int initLevel, SegmentFactory segmentFactory, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, 10000, 5, 256, segmentFactory, 0.5, 0.75, hashFunction);
    }

    public DynamicDataSet(File homeDir, int initLevel, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, 10000, 5, segmentFileSizeMB, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataSet(File homeDir, int initLevel, int segmentFileSizeMB, SegmentFactory segmentFactory, double hashLoadThreshold, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, 10000, 5, segmentFileSizeMB, segmentFactory, 0.5, hashLoadThreshold, hashFunction);
    }

    public DynamicDataSet(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, 0.75, new FnvHashFunction());
    }

    public DynamicDataSet(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double hashLoadFactor, HashFunction<byte[]> hashFunction) throws Exception {
        this(homeDir, initLevel, batchSize, numSyncBatches, segmentFileSizeMB, segmentFactory, 0.5, hashLoadFactor, hashFunction);
    }

    public DynamicDataSet(File homeDir, int initLevel, int batchSize, int numSyncBatches, int segmentFileSizeMB, SegmentFactory segmentFactory, double segmentCompactFactor, double hashLoadFactor, HashFunction<byte[]> hashFunction) throws Exception {
        LinearHashing h = new LinearHashing(65536);
        h.reinit(Integer.MAX_VALUE);
        this._maxLevel = h.getLevel();
        int initialCapacity = 65536;
        if (initLevel >= 0) {
            if (initLevel > this._maxLevel) {
                _log.warn((Object)("initLevel reset from " + initLevel + " to " + this._maxLevel));
                initLevel = this._maxLevel;
            }
            initialCapacity = 65536 << initLevel;
        } else {
            _log.warn((Object)("initLevel ignored: " + initLevel));
        }
        this._homeDir = homeDir;
        this._config = new StoreConfig(this._homeDir, initialCapacity);
        this._config.setBatchSize(batchSize);
        this._config.setNumSyncBatches(numSyncBatches);
        this._config.setSegmentFileSizeMB(segmentFileSizeMB);
        this._config.setSegmentCompactFactor(segmentCompactFactor);
        this._config.setSegmentFactory(segmentFactory);
        this._config.setHashLoadFactor(hashLoadFactor);
        this._config.setHashFunction(hashFunction);
        this._config.validate();
        this._config.save();
        this._dataHandler = new DefaultDataSetHandler();
        this._addrArray = this.createAddressArray(this._config.getHomeDir(), this._config.getBatchSize(), this._config.getNumSyncBatches(), this._config.getIndexesCached());
        this._addrArray.expandCapacity(initialCapacity - 1);
        this._unitCapacity = 65536;
        String segmentHome = homeDir.getCanonicalPath() + File.separator + "segs";
        SegmentManager segmentManager = SegmentManager.getInstance(segmentHome, this._config.getSegmentFactory(), this._config.getSegmentFileSizeMB());
        this._dataArray = new SimpleDataArray(this._addrArray, segmentManager, this._config.getSegmentCompactFactor());
        this._hashFunction = hashFunction;
        this._loadThreshold = hashLoadFactor;
        this._loadCount = this.scan();
        this.initLinearHashing();
        _log.info((Object)this.getStatus());
    }

    protected AddressArray createAddressArray(File homeDir, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createDynamicAddressArray(homeDir, batchSize, numSyncBatches);
        return addrArray;
    }

    protected long hash(byte[] value) {
        return this._hashFunction.hash(value);
    }

    protected long nextScn() {
        return System.currentTimeMillis();
    }

    @Override
    public final int capacity() {
        return this._dataArray.length();
    }

    @Override
    public synchronized void sync() throws IOException {
        this._dataArray.sync();
    }

    @Override
    public synchronized void persist() throws IOException {
        this._dataArray.persist();
    }

    @Override
    public boolean has(byte[] value) {
        byte[] existingData;
        if (value == null) {
            return false;
        }
        long hashCode = this.hash(value);
        int index = this.getIndex(hashCode);
        while (true) {
            existingData = this._dataArray.get(index);
            int indexNew = this.getIndex(hashCode);
            if (index == indexNew) break;
            index = indexNew;
        }
        return existingData == null ? false : this._dataHandler.find(value, existingData);
    }

    public final int countCollisions(byte[] value) {
        byte[] existingData;
        long hashCode = this.hash(value);
        int index = this.getIndex(hashCode);
        while (true) {
            existingData = this._dataArray.get(index);
            int indexNew = this.getIndex(hashCode);
            if (index == indexNew) break;
            index = indexNew;
        }
        return existingData == null ? 0 : this._dataHandler.countCollisions(value, existingData);
    }

    public final boolean hasWithoutCollisions(byte[] value) {
        return this.countCollisions(value) == 1;
    }

    @Override
    public synchronized boolean add(byte[] value) throws Exception {
        if (value == null) {
            return false;
        }
        if (this.canSplit()) {
            this.split();
        }
        int index = this.getIndex(value);
        return this.addInternal(index, value);
    }

    @Override
    public synchronized boolean delete(byte[] value) throws Exception {
        if (value == null) {
            return false;
        }
        if (this.canSplit()) {
            this.split();
        }
        int index = this.getIndex(value);
        return this.deleteInternal(index, value);
    }

    @Override
    public synchronized void clear() throws IOException {
        if (this._dataArray.isOpen()) {
            this._dataArray.clear();
            this._loadCount = 0;
        }
    }

    protected final int getIndex(byte[] value) {
        long capacity;
        long hashCode = this.hash(value);
        int index = (int)(hashCode % (capacity = (long)this._levelCapacity));
        if (index < 0) {
            index = -index;
        }
        if (index < this._split && (index = (int)(hashCode % (capacity <<= 1))) < 0) {
            index = -index;
        }
        return index;
    }

    protected final int getIndex(long hashCode) {
        long capacity = this._levelCapacity;
        int index = (int)(hashCode % capacity);
        if (index < 0) {
            index = -index;
        }
        if (index < this._split && (index = (int)(hashCode % (capacity <<= 1))) < 0) {
            index = -index;
        }
        return index;
    }

    protected boolean addInternal(int index, byte[] value) throws Exception {
        byte[] existingData = this._dataArray.get(index);
        try {
            if (existingData == null || existingData.length == 0) {
                this._dataArray.set(index, this._dataHandler.assemble(value), this.nextScn());
                ++this._loadCount;
            } else if (!this._dataHandler.find(value, existingData)) {
                this._dataArray.set(index, this._dataHandler.assemble(value, existingData), this.nextScn());
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Value reset at index=" + index + " value=\"" + new String(value) + "\""), (Throwable)e);
            this._dataArray.set(index, this._dataHandler.assemble(value), this.nextScn());
        }
        return true;
    }

    protected boolean deleteInternal(int index, byte[] value) throws Exception {
        try {
            byte[] existingData = this._dataArray.get(index);
            if (existingData != null) {
                int newLength = this._dataHandler.remove(value, existingData);
                if (newLength == 0) {
                    this._dataArray.set(index, null, this.nextScn());
                    --this._loadCount;
                    return true;
                }
                if (newLength < existingData.length) {
                    this._dataArray.set(index, existingData, 0, newLength, this.nextScn());
                    return true;
                }
            }
        }
        catch (Exception e) {
            _log.warn((Object)("Failed to delete value=\"" + new String(value) + "\""), (Throwable)e);
            this._dataArray.set(index, null, this.nextScn());
        }
        return false;
    }

    public final int getLevel() {
        return this._level;
    }

    public final int getSplit() {
        return this._split;
    }

    public final int getCapacity() {
        return this._dataArray.length();
    }

    public final int getUnitCapacity() {
        return this._unitCapacity;
    }

    public final int getLevelCapacity() {
        return this._levelCapacity;
    }

    public final int getLoadCount() {
        return this._loadCount;
    }

    public final double getLoadFactor() {
        return (double)this._loadCount / (double)this.getCapacity();
    }

    public final double getLoadThreshold() {
        return this._loadThreshold;
    }

    protected void initLinearHashing() throws Exception {
        int unitCount = this.getCapacity() / this.getUnitCapacity();
        if (unitCount <= 1) {
            this._level = 0;
            this._split = 0;
            this._levelCapacity = this.getUnitCapacity();
            this._loadCountThreshold = (int)((double)this.getCapacity() * this._loadThreshold);
        } else {
            this._level = 0;
            for (int remainder = unitCount - 1 >> 1; remainder > 0; remainder >>= 1) {
                ++this._level;
            }
            this._split = (unitCount - (1 << this._level) - 1) * this.getUnitCapacity();
            this._levelCapacity = this.getUnitCapacity() * (1 << this._level);
            this._loadCountThreshold = (int)((double)this.getCapacity() * this._loadThreshold);
            while (this.canSplit()) {
                this.split();
            }
        }
    }

    protected boolean canSplit() {
        int splitTo;
        return (0 < this._split || this._loadCountThreshold < this._loadCount) && Integer.MAX_VALUE > (splitTo = this._levelCapacity + this._split) && splitTo >= this._levelCapacity;
    }

    protected void split() throws Exception {
        this._addrArray.expandCapacity(this._split + this._levelCapacity);
        byte[] data = this._dataArray.get(this._split);
        if (data != null && data.length > 0) {
            ByteBuffer bb = ByteBuffer.wrap(data);
            long newCapacity = (long)this._levelCapacity << 1;
            for (int cnt = bb.getInt(); cnt > 0; --cnt) {
                int len = bb.getInt();
                byte[] value = new byte[len];
                bb.get(value);
                int newIndex = (int)(this.hash(value) % newCapacity);
                if (newIndex < 0) {
                    newIndex = -newIndex;
                }
                if (newIndex == this._split) continue;
                this.deleteInternal(this._split, value);
                this.addInternal(newIndex, value);
            }
        }
        ++this._split;
        if (this._split % this._unitCapacity == 0) {
            _log.info((Object)("split " + this.getStatus()));
        }
        if (this._split == this._levelCapacity) {
            int nextLevel = this._level + 1;
            int nextLevelCapacity = this.getUnitCapacity() * (1 << nextLevel);
            if (nextLevelCapacity > this._levelCapacity) {
                this._split = 0;
                this._level = nextLevel;
                this._levelCapacity = nextLevelCapacity;
                this._loadCountThreshold = (int)((double)this.getCapacity() * this._loadThreshold);
                _log.info((Object)this.getStatus());
            }
        }
    }

    private int scan() {
        int cnt = 0;
        int len = this._dataArray.length();
        for (int i = 0; i < len; ++i) {
            if (!this._dataArray.hasData(i)) continue;
            ++cnt;
        }
        return cnt;
    }

    public synchronized void rehash() throws Exception {
        if (this.isOpen()) {
            while (this.canSplit()) {
                this.split();
            }
        } else {
            throw new StoreClosedException();
        }
        this.sync();
    }

    public String getStatus() {
        StringBuilder buf = new StringBuilder();
        buf.append("mode=").append((Object)(this.isOpen() ? Mode.OPEN : Mode.CLOSED));
        buf.append(" level=").append(this._level);
        buf.append(" split=").append(this._split);
        buf.append(" capacity=").append(this.getCapacity());
        buf.append(" loadCount=").append(this._loadCount);
        buf.append(" loadFactor=").append(this.getLoadFactor());
        return buf.toString();
    }

    public final File getHomeDir() {
        return this._homeDir;
    }

    public final DataArray getDataArray() {
        return this._dataArray;
    }

    @Override
    public boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this._dataArray.isOpen()) {
            try {
                this._dataArray.open();
                this._loadCount = this.scan();
                this.initLinearHashing();
            }
            catch (Exception e) {
                try {
                    this._dataArray.close();
                }
                catch (Exception e2) {
                    _log.error((Object)"Failed to close", (Throwable)e2);
                }
                throw e instanceof IOException ? (IOException)e : new IOException(e);
            }
            _log.info((Object)this.getStatus());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._dataArray.isOpen()) {
            this._dataArray.close();
        }
    }
}

