/*
 * Decompiled with CFR 0.152.
 */
package krati.store;

import java.io.File;
import java.io.IOException;
import krati.core.StoreConfig;
import krati.core.array.AddressArray;
import krati.core.array.AddressArrayFactory;
import krati.core.segment.SegmentFactory;
import krati.store.AbstractDataArray;
import krati.store.ArrayStore;
import org.apache.log4j.Logger;

public final class StaticDataArray
extends AbstractDataArray
implements ArrayStore {
    private static final Logger _log = Logger.getLogger(StaticDataArray.class);

    public StaticDataArray(StoreConfig config) throws Exception {
        super(config);
    }

    public StaticDataArray(int length, File homeDirectory, SegmentFactory segmentFactory) throws Exception {
        this(length, 10000, 5, homeDirectory, segmentFactory, 256, 0.5);
    }

    public StaticDataArray(int length, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB) throws Exception {
        this(length, 10000, 5, homeDirectory, segmentFactory, segmentFileSizeMB, 0.5);
    }

    public StaticDataArray(int length, int batchSize, int numSyncBatches, File homeDirectory, SegmentFactory segmentFactory, int segmentFileSizeMB, double segmentCompactFactor) throws Exception {
        super(length, batchSize, numSyncBatches, homeDirectory, segmentFactory, segmentFileSizeMB, segmentCompactFactor);
        _log.info((Object)("init " + this.getStatus()));
    }

    @Override
    protected AddressArray createAddressArray(File homeDir, int length, int batchSize, int numSyncBatches, boolean indexesCached) throws Exception {
        AddressArrayFactory factory = new AddressArrayFactory(indexesCached);
        AddressArray addrArray = factory.createStaticAddressArray(homeDir, length, batchSize, numSyncBatches);
        if (length != addrArray.length()) {
            _log.warn((Object)("array file length " + addrArray.length() + " is different from specified " + length));
        }
        return addrArray;
    }

    @Override
    public synchronized void delete(int index, long scn) throws Exception {
        if (this.hasIndex(index)) {
            this._dataArray.set(index, null, scn);
        }
    }

    @Override
    public final int getIndexStart() {
        return 0;
    }

    @Override
    public final int capacity() {
        return this.length();
    }

    @Override
    public final boolean isOpen() {
        return this._dataArray.isOpen();
    }

    @Override
    public synchronized void open() throws IOException {
        this._dataArray.open();
    }

    @Override
    public synchronized void close() throws IOException {
        this._dataArray.close();
    }
}

