/*
 * Decompiled with CFR 0.152.
 */
package krati.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class SourceWaterMarks {
    private File file;
    private File fileOriginal;
    private final Map<String, WaterMarkEntry> sourceWaterMarkMap;
    private static final Logger logger = Logger.getLogger(SourceWaterMarks.class);

    public SourceWaterMarks(File file) {
        this.file = file;
        this.fileOriginal = new File(file.getPath() + ".original");
        this.sourceWaterMarkMap = new HashMap<String, WaterMarkEntry>();
        try {
            this.loadWaterMarks();
            for (String source : this.sourceWaterMarkMap.keySet()) {
                WaterMarkEntry wmEntry = this.sourceWaterMarkMap.get(source);
                logger.info((Object)("Loaded water mark entry: " + wmEntry));
            }
        }
        catch (Exception ioe) {
            logger.error((Object)"Failed to load water marks");
        }
    }

    public File getFile() {
        return this.file;
    }

    public File getFileOriginal() {
        return this.fileOriginal;
    }

    protected void loadWaterMarks() throws IOException {
        block3: {
            if (this.file != null && this.file.exists()) {
                try {
                    this.loadWaterMarks(this.file);
                }
                catch (IOException e) {
                    if (this.fileOriginal == null || !this.fileOriginal.exists()) break block3;
                    this.loadWaterMarks(this.fileOriginal);
                }
            }
        }
    }

    protected void loadWaterMarks(File waterMarksFile) throws IOException {
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(waterMarksFile);
        logger.info((Object)("Loading " + waterMarksFile));
        try {
            p.load(fis);
            Enumeration<?> enm = p.propertyNames();
            while (enm.hasMoreElements()) {
                WaterMarkEntry wmEntry;
                String source = (String)enm.nextElement();
                String waterMarks = p.getProperty(source);
                String[] parts = waterMarks.split(",");
                if (parts.length != 2) continue;
                long lwmScn = Long.parseLong(parts[0].trim());
                long hwmScn = Long.parseLong(parts[1].trim());
                if (hwmScn < lwmScn) {
                    lwmScn = hwmScn;
                }
                if ((wmEntry = this.sourceWaterMarkMap.get(source)) == null) {
                    wmEntry = new WaterMarkEntry(source);
                    this.sourceWaterMarkMap.put(source, wmEntry);
                }
                wmEntry.setLWMScn(lwmScn);
                wmEntry.setHWMScn(hwmScn);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load source water marks from " + waterMarksFile.getName()), (Throwable)e);
            throw e;
        }
        finally {
            fis.close();
            fis = null;
        }
    }

    public Set<String> sources() {
        return this.sourceWaterMarkMap.keySet();
    }

    public long getHWMScn(String source) {
        WaterMarkEntry e = this.sourceWaterMarkMap.get(source);
        return e == null ? 0L : e.getHWMScn();
    }

    public void setHWMScn(String source, long scn) {
        WaterMarkEntry e = this.sourceWaterMarkMap.get(source);
        if (e == null) {
            e = new WaterMarkEntry(source);
            this.sourceWaterMarkMap.put(source, e);
        }
        e.setHWMScn(scn);
    }

    public long getLWMScn(String source) {
        WaterMarkEntry e = this.sourceWaterMarkMap.get(source);
        return e == null ? 0L : e.getLWMScn();
    }

    public void setLWMScn(String source, long scn) {
        WaterMarkEntry e = this.sourceWaterMarkMap.get(source);
        if (e == null) {
            e = new WaterMarkEntry(source);
            this.sourceWaterMarkMap.put(source, e);
        }
        e.setLWMScn(scn);
    }

    public void saveHWMark(String source, long hwm) {
        WaterMarkEntry wmEntry = this.sourceWaterMarkMap.get(source);
        if (wmEntry != null) {
            wmEntry.setHWMScn(Math.max(hwm, wmEntry.getHWMScn()));
        } else {
            wmEntry = new WaterMarkEntry(source);
            wmEntry.setHWMScn(hwm);
            this.sourceWaterMarkMap.put(source, wmEntry);
        }
    }

    public void setWaterMarks(String source, long lwmScn, long hwmScn) {
        WaterMarkEntry e = this.sourceWaterMarkMap.get(source);
        if (e == null) {
            e = new WaterMarkEntry(source);
            this.sourceWaterMarkMap.put(source, e);
        }
        e.setLWMScn(lwmScn);
        e.setHWMScn(hwmScn);
    }

    public boolean syncWaterMarks(String source, long lwmScn, long hwmScn) {
        this.setWaterMarks(source, lwmScn, hwmScn);
        return this.syncWaterMarks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncWaterMarks() {
        WaterMarkEntry wmEntry;
        boolean ret = true;
        PrintWriter out = null;
        for (String source : this.sourceWaterMarkMap.keySet()) {
            wmEntry = this.sourceWaterMarkMap.get(source);
            wmEntry.setLWMScn(wmEntry.getHWMScn());
        }
        try {
            if (this.file.exists()) {
                if (this.fileOriginal.exists()) {
                    this.fileOriginal.delete();
                }
                this.file.renameTo(this.fileOriginal);
            }
            out = new PrintWriter(new FileOutputStream(this.file));
            for (String source : this.sourceWaterMarkMap.keySet()) {
                wmEntry = this.sourceWaterMarkMap.get(source);
                out.println(wmEntry);
            }
            out.flush();
        }
        catch (IOException ioe) {
            logger.error((Object)"Failed to sync water marks", (Throwable)ioe);
            ret = false;
        }
        finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
        return ret;
    }

    public void clear() {
        this.sourceWaterMarkMap.clear();
        this.syncWaterMarks();
        if (this.fileOriginal != null && this.fileOriginal.exists()) {
            this.fileOriginal.delete();
        }
    }

    static class WaterMarkEntry {
        private long lwmScn = 0L;
        private long hwmScn = 0L;
        private final String source;

        public WaterMarkEntry(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }

        public long getLWMScn() {
            return this.lwmScn;
        }

        public void setLWMScn(long scn) {
            this.lwmScn = scn;
        }

        public long getHWMScn() {
            return this.hwmScn;
        }

        public void setHWMScn(long scn) {
            this.hwmScn = scn;
        }

        public String toString() {
            return this.source + "=" + this.lwmScn + "," + this.hwmScn;
        }

        public int hashCode() {
            int hash = (int)((this.lwmScn & this.hwmScn) >> 32);
            return hash += this.source.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof WaterMarkEntry) {
                WaterMarkEntry e = (WaterMarkEntry)o;
                return this.source.equals(e.source) && this.lwmScn == e.lwmScn && this.hwmScn == e.hwmScn;
            }
            return false;
        }
    }
}

