/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.JoinInfo;
import com.hazelcast.config.Config;
import com.hazelcast.impl.MulticastListener;
import com.hazelcast.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.UnboundedBlockingQueue;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class MulticastService
implements Runnable {
    private final ILogger logger;
    private final BlockingQueue<Runnable> queue = new UnboundedBlockingQueue<Runnable>();
    private final MulticastSocket multicastSocket;
    private final DatagramPacket datagramPacketSend;
    private final DatagramPacket datagramPacketReceive;
    private final Object sendLock = new Object();
    private final Object receiveLock = new Object();
    final Node node;
    private boolean running = true;
    private List<MulticastListener> lsListeners = new CopyOnWriteArrayList<MulticastListener>();

    public MulticastService(Node node, MulticastSocket multicastSocket) throws Exception {
        this.node = node;
        this.logger = node.getLogger(MulticastService.class.getName());
        Config config = node.getConfig();
        this.multicastSocket = multicastSocket;
        int bufferSize = 65536;
        this.datagramPacketReceive = new DatagramPacket(new byte[bufferSize], bufferSize);
        this.datagramPacketSend = new DatagramPacket(new byte[bufferSize], bufferSize, InetAddress.getByName(config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastGroup()), config.getNetworkConfig().getJoin().getMulticastConfig().getMulticastPort());
        this.running = true;
    }

    public void addMulticastListener(MulticastListener multicastListener) {
        this.lsListeners.add(multicastListener);
    }

    public void removeMulticastListener(MulticastListener multicastListener) {
        this.lsListeners.remove(multicastListener);
    }

    public void stop() {
        try {
            final CountDownLatch l = new CountDownLatch(1);
            this.queue.put(new Runnable(){

                public void run() {
                    MulticastService.this.running = false;
                    l.countDown();
                }
            });
            l.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (this.running) {
            try {
                Runnable runnable = (Runnable)this.queue.poll();
                if (runnable != null) {
                    runnable.run();
                    return;
                }
                JoinInfo joinInfo = this.receive();
                if (joinInfo == null) continue;
                for (MulticastListener multicastListener : this.lsListeners) {
                    multicastListener.onMessage(joinInfo);
                }
            }
            catch (OutOfMemoryError e) {
                this.node.onOutOfMemory(e);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinInfo receive() {
        Object object = this.receiveLock;
        synchronized (object) {
            try {
                try {
                    this.multicastSocket.receive(this.datagramPacketReceive);
                }
                catch (SocketTimeoutException ignore) {
                    return null;
                }
                JoinInfo joinInfo = new JoinInfo();
                joinInfo.readFromPacket(this.datagramPacketReceive);
                return joinInfo;
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JoinInfo joinInfo) {
        Object object = this.sendLock;
        synchronized (object) {
            try {
                joinInfo.writeToPacket(this.datagramPacketSend);
                this.multicastSocket.send(this.datagramPacketSend);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "You probably have too long Hazelcast configuration!", e);
            }
        }
    }
}

