/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.rest;

import com.hazelcast.impl.ascii.NoOpCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.rest.HttpCommand;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ascii.SocketTextReader;
import java.nio.ByteBuffer;

public class HttpPostCommand
extends HttpCommand {
    private ByteBuffer data = null;
    boolean nextLine = false;
    boolean readyToReadData = false;
    private ByteBuffer line = ByteBuffer.allocate(500);
    private String contentType = "text/html";
    private final SocketTextReader socketTextRequestReader;
    private boolean chunked = false;

    public HttpPostCommand(SocketTextReader socketTextRequestReader, String uri) {
        super(TextCommandConstants.TextCommandType.HTTP_POST, uri);
        this.socketTextRequestReader = socketTextRequestReader;
    }

    public boolean doRead(ByteBuffer cb) {
        boolean complete = this.doActualRead(cb);
        while (!complete && this.readyToReadData && this.chunked && cb.hasRemaining()) {
            complete = this.doActualRead(cb);
        }
        if (complete && this.data != null) {
            this.data.flip();
        }
        return complete;
    }

    public byte[] getData() {
        return this.data == null ? null : this.data.array();
    }

    public byte[] getContentType() {
        return this.contentType == null ? null : this.contentType.getBytes();
    }

    public boolean doActualRead(ByteBuffer cb) {
        if (this.readyToReadData) {
            if (this.chunked && (this.data == null || !this.data.hasRemaining())) {
                boolean hasLine = this.readLine(cb);
                String lineStr = null;
                if (hasLine) {
                    lineStr = this.toStringAndClear(this.line).trim();
                }
                if (hasLine) {
                    int dataSize;
                    int n = dataSize = lineStr.length() == 0 ? 0 : Integer.parseInt(lineStr, 16);
                    if (dataSize == 0) {
                        return true;
                    }
                    if (this.data != null) {
                        ByteBuffer newData = ByteBuffer.allocate(this.data.capacity() + dataSize);
                        newData.put(this.data.array());
                        this.data = newData;
                    } else {
                        this.data = ByteBuffer.allocate(dataSize);
                    }
                }
            }
            IOUtil.copyToHeapBuffer(cb, this.data);
        }
        while (!this.readyToReadData && cb.hasRemaining()) {
            byte b = cb.get();
            char c = (char)b;
            if (c == '\n') {
                this.processLine(this.toStringAndClear(this.line));
                if (this.nextLine) {
                    this.readyToReadData = true;
                }
                this.nextLine = true;
                continue;
            }
            if (c == '\r') continue;
            this.nextLine = false;
            this.line.put(b);
        }
        return !this.chunked && this.data != null && !this.data.hasRemaining();
    }

    String toStringAndClear(ByteBuffer bb) {
        if (bb == null) {
            return "";
        }
        String result = null;
        result = bb.position() == 0 ? "" : new String(bb.array(), 0, bb.position());
        bb.clear();
        return result;
    }

    boolean readLine(ByteBuffer cb) {
        while (cb.hasRemaining()) {
            byte b = cb.get();
            char c = (char)b;
            if (c == '\n') {
                return true;
            }
            if (c == '\r') continue;
            this.line.put(b);
        }
        return false;
    }

    private void processLine(String currentLine) {
        if (this.contentType == null && currentLine.startsWith("Content-Type: ")) {
            this.contentType = currentLine.substring(currentLine.indexOf(32) + 1);
        } else if (this.data == null && currentLine.startsWith("Content-Length: ")) {
            this.data = ByteBuffer.allocate(Integer.parseInt(currentLine.substring(currentLine.indexOf(32) + 1)));
        } else if (!this.chunked && currentLine.startsWith("Transfer-Encoding: chunked")) {
            this.chunked = true;
        } else if (currentLine.startsWith("Expect: 100")) {
            this.socketTextRequestReader.sendResponse(new NoOpCommand(RES_100));
        }
    }
}

