/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public final class FastByteArrayOutputStream
extends ByteArrayOutputStream
implements DataOutput {
    private final byte[] writeBuffer = new byte[8];
    private static final int STRING_CHUNK_SIZE = 16384;

    public FastByteArrayOutputStream() {
        this(32);
    }

    public FastByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void set(byte[] buffer) {
        this.buf = buffer;
    }

    public void reset() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v & 0xFF);
        }
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        this.writeBuffer[0] = (byte)(v >>> 56);
        this.writeBuffer[1] = (byte)(v >>> 48);
        this.writeBuffer[2] = (byte)(v >>> 40);
        this.writeBuffer[3] = (byte)(v >>> 32);
        this.writeBuffer[4] = (byte)(v >>> 24);
        this.writeBuffer[5] = (byte)(v >>> 16);
        this.writeBuffer[6] = (byte)(v >>> 8);
        this.writeBuffer[7] = (byte)v;
        this.write(this.writeBuffer, 0, 8);
    }

    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeUTF(String str) throws IOException {
        int length = str.length();
        int chunkSize = length / 16384 + 1;
        this.writeInt(chunkSize);
        for (int i = 0; i < chunkSize; ++i) {
            int beginIndex = Math.max(0, i * 16384 - 1);
            int endIndex = Math.min((i + 1) * 16384 - 1, length);
            this.writeShortUTF(str.substring(beginIndex, endIndex));
        }
    }

    private final void writeShortUTF(String str) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen & 0xFF);
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        this.write(bytearr, 0, utflen + 2);
    }
}

