/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLReader;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.xml.DescriptionElement;

public abstract class WSDLFactory {
    private static final String PROPERTY_NAME = "org.apache.woden.WSDLFactory";
    private static final String PROPERTY_FILE_NAME = "wsdl.properties";
    private static final String DEFAULT_FACTORY_IMPL_NAME = "org.apache.woden.internal.DOMWSDLFactory";
    private static String fFullPropertyFileName = null;

    public static WSDLFactory newInstance() throws WSDLException {
        String string = WSDLFactory.findFactoryImplName();
        return WSDLFactory.newInstance(string);
    }

    public static WSDLFactory newInstance(String string) throws WSDLException {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                return (WSDLFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating a WSDLFactory implementation using factory impl name '" + string + "' ", exception);
            }
        }
        throw new WSDLException("CONFIGURATION_ERROR", "Unable to find the name of a WSDLFactory implementation class.");
    }

    private static String findFactoryImplName() throws WSDLException {
        String string = null;
        try {
            string = System.getProperty(PROPERTY_NAME);
            if (string != null) {
                return string;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string2 = WSDLFactory.getFullPropertyFileName();
        if (string2 != null) {
            try {
                Properties properties = new Properties();
                File file = new File(string2);
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
                string = properties.getProperty(PROPERTY_NAME);
                if (string != null) {
                    return string;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem loading the properties file '" + string2 + "' ", iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem with the content of the properties file '" + string2 + "' ", illegalArgumentException);
            }
        }
        return DEFAULT_FACTORY_IMPL_NAME;
    }

    private static String getFullPropertyFileName() {
        if (fFullPropertyFileName == null) {
            try {
                String string = System.getProperty("java.home");
                fFullPropertyFileName = string + File.separator + "lib" + File.separator + PROPERTY_FILE_NAME;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return fFullPropertyFileName;
    }

    public abstract WSDLReader newWSDLReader() throws WSDLException;

    public abstract DescriptionElement newDescription();

    public abstract ExtensionRegistry newPopulatedExtensionRegistry();
}

