/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal;

import org.apache.woden.ErrorReporter;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.internal.ErrorReporterImpl;
import org.apache.woden.internal.ReaderFeatures;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;

public abstract class BaseWSDLReader
implements WSDLReader {
    private WSDLFactory fFactory;
    private String fFactoryImplName = null;
    private ErrorReporter fErrorReporter = new ErrorReporterImpl();
    private ExtensionRegistry fExtReg;
    protected ReaderFeatures features = new ReaderFeatures();

    protected BaseWSDLReader() throws WSDLException {
    }

    public ErrorReporter getErrorReporter() {
        return this.fErrorReporter;
    }

    protected WSDLFactory getFactory() throws WSDLException {
        if (this.fFactory == null) {
            this.fFactory = this.fFactoryImplName != null ? WSDLFactory.newInstance(this.fFactoryImplName) : WSDLFactory.newInstance();
        }
        return this.fFactory;
    }

    public void setFactoryImplName(String string) {
        this.fFactory = null;
        this.fFactoryImplName = string;
    }

    public String getFactoryImplName() {
        return this.fFactoryImplName;
    }

    public void setExtensionRegistry(ExtensionRegistry extensionRegistry) {
        this.fExtReg = extensionRegistry;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.fExtReg;
    }

    public void setFeature(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL005", null));
        }
        try {
            this.features.setValue(string, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL006", objectArray));
        }
    }

    public boolean getFeature(String string) {
        if (string == null) {
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL005", null));
        }
        try {
            return this.features.getValue(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL006", objectArray));
        }
    }

    public void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL007", null));
        }
        if (!string.equals("xyz")) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL008", objectArray));
        }
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL007", null));
        }
        if (string.equals("xyz")) {
            return null;
        }
        Object[] objectArray = new Object[]{string};
        throw new IllegalArgumentException(this.fErrorReporter.getFormattedMessage("WSDL008", objectArray));
    }
}

