/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.state.SMPPSessionBound;
import org.jsmpp.session.state.SMPPSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPSessionBoundRX
extends SMPPSessionBound
implements SMPPSessionState {
    private static final Logger logger = LoggerFactory.getLogger(SMPPSessionBoundRX.class);
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();

    SMPPSessionBoundRX() {
    }

    public SessionState getSessionState() {
        return SessionState.BOUND_RX;
    }

    public void processDeliverSm(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        SMPPSessionBoundRX.processDeliverSm0(pduHeader, pdu, responseHandler);
    }

    public void processSubmitSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    public void processSubmitMultiResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    public void processQuerySmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    public void processCancelSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    public void processReplaceSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    public void processAlertNotification(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) {
        SMPPSessionBoundRX.processAlertNotification0(pduHeader, pdu, responseHandler);
    }

    static void processAlertNotification0(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) {
        try {
            AlertNotification alertNotification = pduDecomposer.alertNotification(pdu);
            responseHandler.processAlertNotification(alertNotification);
        }
        catch (PDUStringException e) {
            logger.error("Failed decomposing alert_notification", (Throwable)e);
        }
    }

    static void processDeliverSm0(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        try {
            DeliverSm deliverSm = pduDecomposer.deliverSm(pdu);
            responseHandler.processDeliverSm(deliverSm);
            responseHandler.sendDeliverSmResp(pduHeader.getSequenceNumber());
        }
        catch (PDUStringException e) {
            logger.error("Failed decomposing deliver_sm", (Throwable)e);
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (ProcessRequestException e) {
            logger.error("Failed processing deliver_sm", (Throwable)e);
            responseHandler.sendNegativeResponse(pduHeader.getCommandId(), e.getErrorCode(), pduHeader.getSequenceNumber());
        }
    }
}

