/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.jsmpp.InvalidNumberOfDestinationsException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.BindResp;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.CancelSmResp;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DataSmResp;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliverSmResp;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.DistributionList;
import org.jsmpp.bean.EnquireLink;
import org.jsmpp.bean.EnquireLinkResp;
import org.jsmpp.bean.GenericNack;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;
import org.jsmpp.bean.Outbind;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.QuerySmResp;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.ReplaceSmResp;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitMultiResp;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.SubmitSmResp;
import org.jsmpp.bean.Unbind;
import org.jsmpp.bean.UnbindResp;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.InvalidDeliveryReceiptException;
import org.jsmpp.util.PDUDecomposer;
import org.jsmpp.util.SequentialBytesReader;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecomposer
implements PDUDecomposer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDecomposer.class);
    private static final PDUDecomposer instance = new DefaultDecomposer();

    public static final PDUDecomposer getInstance() {
        return instance;
    }

    public Command header(byte[] b) {
        Command pdu = new Command();
        DefaultDecomposer.assignHeader(pdu, b);
        return pdu;
    }

    public Bind bind(byte[] b) throws PDUStringException {
        Bind req = new Bind();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setSystemId(reader.readCString());
        StringValidator.validateString(req.getSystemId(), StringParameter.SYSTEM_ID);
        req.setPassword(reader.readCString());
        StringValidator.validateString(req.getPassword(), StringParameter.PASSWORD);
        req.setSystemType(reader.readCString());
        StringValidator.validateString(req.getSystemType(), StringParameter.SYSTEM_TYPE);
        req.setInterfaceVersion(reader.readByte());
        req.setAddrTon(reader.readByte());
        req.setAddrNpi(reader.readByte());
        req.setAddressRange(reader.readCString());
        StringValidator.validateString(req.getAddressRange(), StringParameter.ADDRESS_RANGE);
        return req;
    }

    public BindResp bindResp(byte[] b) throws PDUStringException {
        BindResp resp = new BindResp();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)resp, reader);
        if (resp.getCommandLength() > 16 && resp.getCommandStatus() == 0) {
            resp.setSystemId(reader.readCString());
            StringValidator.validateString(resp.getSystemId(), StringParameter.SYSTEM_ID);
            resp.setOptionalParameters(this.readOptionalParameters(reader));
        }
        return resp;
    }

    public Unbind unbind(byte[] b) {
        Unbind req = new Unbind();
        DefaultDecomposer.assignHeader((Command)req, b);
        return req;
    }

    public UnbindResp unbindResp(byte[] b) {
        UnbindResp resp = new UnbindResp();
        DefaultDecomposer.assignHeader((Command)resp, b);
        return resp;
    }

    public Outbind outbind(byte[] b) throws PDUStringException {
        Outbind req = new Outbind();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setSystemId(reader.readCString());
        StringValidator.validateString(req.getSystemId(), StringParameter.SYSTEM_ID);
        req.setPassword(reader.readCString());
        StringValidator.validateString(req.getPassword(), StringParameter.PASSWORD);
        return req;
    }

    public EnquireLink enquireLink(byte[] b) {
        EnquireLink req = new EnquireLink();
        DefaultDecomposer.assignHeader((Command)req, b);
        return req;
    }

    public EnquireLinkResp enquireLinkResp(byte[] b) {
        EnquireLinkResp resp = new EnquireLinkResp();
        DefaultDecomposer.assignHeader((Command)resp, b);
        return resp;
    }

    public GenericNack genericNack(byte[] b) {
        GenericNack req = new GenericNack();
        DefaultDecomposer.assignHeader((Command)req, b);
        return req;
    }

    public SubmitSm submitSm(byte[] b) throws PDUStringException {
        SubmitSm req = new SubmitSm();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setServiceType(reader.readCString());
        StringValidator.validateString(req.getServiceType(), StringParameter.SERVICE_TYPE);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        req.setDestAddrTon(reader.readByte());
        req.setDestAddrNpi(reader.readByte());
        req.setDestAddress(reader.readCString());
        StringValidator.validateString(req.getDestAddress(), StringParameter.DESTINATION_ADDR);
        req.setEsmClass(reader.readByte());
        req.setProtocolId(reader.readByte());
        req.setPriorityFlag(reader.readByte());
        req.setScheduleDeliveryTime(reader.readCString());
        StringValidator.validateString(req.getScheduleDeliveryTime(), StringParameter.SCHEDULE_DELIVERY_TIME);
        req.setValidityPeriod(reader.readCString());
        StringValidator.validateString(req.getValidityPeriod(), StringParameter.VALIDITY_PERIOD);
        req.setRegisteredDelivery(reader.readByte());
        req.setReplaceIfPresent(reader.readByte());
        req.setDataCoding(reader.readByte());
        req.setSmDefaultMsgId(reader.readByte());
        byte smLength = reader.readByte();
        req.setShortMessage(reader.readBytes(smLength));
        StringValidator.validateString(req.getShortMessage(), StringParameter.SHORT_MESSAGE);
        req.setOptionalParametes(this.readOptionalParameters(reader));
        return req;
    }

    public SubmitSmResp submitSmResp(byte[] b) throws PDUStringException {
        SubmitSmResp resp = new SubmitSmResp();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)resp, reader);
        if (resp.getCommandLength() > 16 && resp.getCommandStatus() == 0) {
            resp.setMessageId(reader.readCString());
            StringValidator.validateString(resp.getMessageId(), StringParameter.MESSAGE_ID);
        }
        return resp;
    }

    public QuerySm querySm(byte[] b) throws PDUStringException {
        QuerySm req = new QuerySm();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setMessageId(reader.readCString());
        StringValidator.validateString(req.getMessageId(), StringParameter.MESSAGE_ID);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        return req;
    }

    public QuerySmResp querySmResp(byte[] b) throws PDUStringException {
        QuerySmResp resp = new QuerySmResp();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)resp, reader);
        if (resp.getCommandLength() > 16 && resp.getCommandStatus() == 0) {
            resp.setMessageId(reader.readCString());
            StringValidator.validateString(resp.getMessageId(), StringParameter.MESSAGE_ID);
            resp.setFinalDate(reader.readCString());
            StringValidator.validateString(resp.getFinalDate(), StringParameter.FINAL_DATE);
            resp.setMessageState(MessageState.valueOf(reader.readByte()));
            resp.setErrorCode(reader.readByte());
        }
        return resp;
    }

    public DeliverSm deliverSm(byte[] b) throws PDUStringException {
        DeliverSm req = new DeliverSm();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setServiceType(reader.readCString());
        StringValidator.validateString(req.getServiceType(), StringParameter.SERVICE_TYPE);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        req.setDestAddrTon(reader.readByte());
        req.setDestAddrNpi(reader.readByte());
        req.setDestAddress(reader.readCString());
        StringValidator.validateString(req.getDestAddress(), StringParameter.DESTINATION_ADDR);
        req.setEsmClass(reader.readByte());
        req.setProtocolId(reader.readByte());
        req.setPriorityFlag(reader.readByte());
        req.setScheduleDeliveryTime(reader.readCString());
        StringValidator.validateString(req.getScheduleDeliveryTime(), StringParameter.SCHEDULE_DELIVERY_TIME);
        req.setValidityPeriod(reader.readCString());
        StringValidator.validateString(req.getValidityPeriod(), StringParameter.VALIDITY_PERIOD);
        req.setRegisteredDelivery(reader.readByte());
        req.setReplaceIfPresent(reader.readByte());
        req.setDataCoding(reader.readByte());
        req.setSmDefaultMsgId(reader.readByte());
        byte smLength = reader.readByte();
        req.setShortMessage(reader.readBytes(smLength));
        StringValidator.validateString(req.getShortMessage(), StringParameter.SHORT_MESSAGE);
        req.setOptionalParametes(this.readOptionalParameters(reader));
        return req;
    }

    public DeliverSmResp deliverSmResp(byte[] b) {
        DeliverSmResp resp = new DeliverSmResp();
        SequentialBytesReader reader = new SequentialBytesReader(b);
        DefaultDecomposer.assignHeader((Command)resp, reader);
        return resp;
    }

    public DeliveryReceipt deliveryReceipt(String data) throws InvalidDeliveryReceiptException {
        try {
            DeliveryReceipt delRec = new DeliveryReceipt();
            delRec.setId(DefaultDecomposer.getDeliveryReceiptValue("id", data));
            delRec.setSubmitted(Integer.parseInt(DefaultDecomposer.getDeliveryReceiptValue("sub", data)));
            delRec.setDelivered(Integer.parseInt(DefaultDecomposer.getDeliveryReceiptValue("dlvrd", data)));
            delRec.setSubmitDate(DefaultDecomposer.string2Date(DefaultDecomposer.getDeliveryReceiptValue("submit date", data)));
            delRec.setDoneDate(DefaultDecomposer.string2Date(DefaultDecomposer.getDeliveryReceiptValue("done date", data)));
            delRec.setFinalStatus(DeliveryReceiptState.getByName(DefaultDecomposer.getDeliveryReceiptValue("stat", data)));
            delRec.setError(DefaultDecomposer.getDeliveryReceiptValue("err", data));
            delRec.setText(DefaultDecomposer.getDeliveryReceiptTextValue(data));
            return delRec;
        }
        catch (Exception e) {
            throw new InvalidDeliveryReceiptException("There is an error found when parsing delivery receipt", e);
        }
    }

    public DeliveryReceipt deliveryReceipt(byte[] data) throws InvalidDeliveryReceiptException {
        return this.deliveryReceipt(new String(data));
    }

    public DataSm dataSm(byte[] data) throws PDUStringException {
        DataSm req = new DataSm();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setServiceType(reader.readCString());
        StringValidator.validateString(req.getServiceType(), StringParameter.SERVICE_TYPE);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        req.setDestAddrTon(reader.readByte());
        req.setDestAddrNpi(reader.readByte());
        req.setDestAddress(reader.readCString());
        StringValidator.validateString(req.getDestAddress(), StringParameter.DESTINATION_ADDR);
        req.setEsmClass(reader.readByte());
        req.setRegisteredDelivery(reader.readByte());
        req.setDataCoding(reader.readByte());
        req.setOptionalParametes(this.readOptionalParameters(reader));
        return req;
    }

    public DataSmResp dataSmResp(byte[] data) throws PDUStringException {
        DataSmResp resp = new DataSmResp();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)resp, reader);
        if (resp.getCommandLength() > 16 && resp.getCommandStatus() == 0) {
            resp.setMessageId(reader.readCString());
            StringValidator.validateString(resp.getMessageId(), StringParameter.MESSAGE_ID);
        }
        return resp;
    }

    public CancelSm cancelSm(byte[] data) throws PDUStringException {
        CancelSm req = new CancelSm();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setServiceType(reader.readCString());
        StringValidator.validateString(req.getServiceType(), StringParameter.SERVICE_TYPE);
        req.setMessageId(reader.readCString());
        StringValidator.validateString(req.getMessageId(), StringParameter.MESSAGE_ID);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        req.setDestAddrTon(reader.readByte());
        req.setDestAddrNpi(reader.readByte());
        req.setDestinationAddress(reader.readCString());
        StringValidator.validateString(req.getDestinationAddress(), StringParameter.DESTINATION_ADDR);
        return req;
    }

    public CancelSmResp cancelSmResp(byte[] data) {
        CancelSmResp resp = new CancelSmResp();
        DefaultDecomposer.assignHeader((Command)resp, data);
        return resp;
    }

    public SubmitMulti submitMulti(byte[] data) throws PDUStringException, InvalidNumberOfDestinationsException {
        SubmitMulti req = new SubmitMulti();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setServiceType(reader.readCString());
        StringValidator.validateString(req.getServiceType(), StringParameter.SERVICE_TYPE);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        int totalDest = 0xFF & reader.readByte();
        if (totalDest > 255) {
            throw new InvalidNumberOfDestinationsException("Number of destination is invalid. Should be no more than 255. Actual number is " + totalDest, totalDest);
        }
        DestinationAddress[] destAddresses = new DestinationAddress[totalDest];
        for (int i = 0; i < totalDest; ++i) {
            byte flag = reader.readByte();
            if (flag == DestinationAddress.Flag.SME_ADDRESS.getValue()) {
                byte ton = reader.readByte();
                byte npi = reader.readByte();
                String addr = reader.readCString();
                StringValidator.validateString(addr, StringParameter.DESTINATION_ADDR);
                Address destAddr = new Address(ton, npi, addr);
                destAddresses[i] = destAddr;
                continue;
            }
            if (flag == DestinationAddress.Flag.DISTRIBUTION_LIST.getValue()) {
                destAddresses[i] = new DistributionList(reader.readCString());
                continue;
            }
            logger.warn("Unknown destination address flag: " + flag);
        }
        req.setDestAddresses(destAddresses);
        req.setEsmClass(reader.readByte());
        req.setProtocolId(reader.readByte());
        req.setPriorityFlag(reader.readByte());
        req.setScheduleDeliveryTime(reader.readCString());
        StringValidator.validateString(req.getScheduleDeliveryTime(), StringParameter.SCHEDULE_DELIVERY_TIME);
        req.setValidityPeriod(reader.readCString());
        StringValidator.validateString(req.getValidityPeriod(), StringParameter.VALIDITY_PERIOD);
        req.setRegisteredDelivery(reader.readByte());
        req.setReplaceIfPresentFlag(reader.readByte());
        req.setDataCoding(reader.readByte());
        req.setSmDefaultMsgId(reader.readByte());
        byte smLength = reader.readByte();
        req.setShortMessage(reader.readBytes(smLength));
        StringValidator.validateString(req.getShortMessage(), StringParameter.SHORT_MESSAGE);
        req.setOptionalParameters(this.readOptionalParameters(reader));
        return req;
    }

    public SubmitMultiResp submitMultiResp(byte[] data) throws PDUStringException {
        SubmitMultiResp resp = new SubmitMultiResp();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)resp, reader);
        resp.setMessageId(reader.readCString());
        StringValidator.validateString(resp.getMessageId(), StringParameter.MESSAGE_ID);
        int noUnsuccess = 0xFF & reader.readByte();
        UnsuccessDelivery[] unsuccessSmes = new UnsuccessDelivery[noUnsuccess];
        for (int i = 0; i < noUnsuccess; ++i) {
            byte ton = reader.readByte();
            byte npi = reader.readByte();
            String addr = reader.readCString();
            StringValidator.validateString(addr, StringParameter.DESTINATION_ADDR);
            int errorStatusCode = reader.readInt();
            unsuccessSmes[i] = new UnsuccessDelivery(ton, npi, addr, errorStatusCode);
        }
        resp.setUnsuccessSmes(unsuccessSmes);
        return resp;
    }

    public ReplaceSm replaceSm(byte[] data) throws PDUStringException {
        ReplaceSm req = new ReplaceSm();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setMessageId(reader.readCString());
        StringValidator.validateString(req.getMessageId(), StringParameter.MESSAGE_ID);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        req.setScheduleDeliveryTime(reader.readCString());
        StringValidator.validateString(req.getScheduleDeliveryTime(), StringParameter.SCHEDULE_DELIVERY_TIME);
        req.setValidityPeriod(reader.readCString());
        StringValidator.validateString(req.getValidityPeriod(), StringParameter.VALIDITY_PERIOD);
        req.setSmDefaultMsgId(reader.readByte());
        byte smLength = reader.readByte();
        req.setShortMessage(reader.readBytes(smLength));
        StringValidator.validateString(req.getShortMessage(), StringParameter.SHORT_MESSAGE);
        return req;
    }

    public ReplaceSmResp replaceSmResp(byte[] data) {
        ReplaceSmResp resp = new ReplaceSmResp();
        DefaultDecomposer.assignHeader((Command)resp, data);
        return resp;
    }

    public AlertNotification alertNotification(byte[] data) throws PDUStringException {
        AlertNotification req = new AlertNotification();
        SequentialBytesReader reader = new SequentialBytesReader(data);
        DefaultDecomposer.assignHeader((Command)req, reader);
        req.setSourceAddrTon(reader.readByte());
        req.setSourceAddrNpi(reader.readByte());
        req.setSourceAddr(reader.readCString());
        StringValidator.validateString(req.getSourceAddr(), StringParameter.SOURCE_ADDR);
        req.setEsmeAddrTon(reader.readByte());
        req.setEsmeAddrNpi(reader.readByte());
        req.setEsmeAddr(reader.readCString());
        req.setOptionalParameters(this.readOptionalParameters(reader));
        return req;
    }

    private OptionalParameter[] readOptionalParameters(SequentialBytesReader reader) {
        if (!reader.hasMoreBytes()) {
            return null;
        }
        ArrayList<OptionalParameter> params = new ArrayList<OptionalParameter>();
        while (reader.hasMoreBytes()) {
            short tag = reader.readShort();
            short length = reader.readShort();
            byte[] content = reader.readBytes(length);
            params.add(OptionalParameters.deserialize(tag, content));
        }
        return params.toArray(new OptionalParameter[params.size()]);
    }

    private static Date string2Date(String date) {
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4));
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        Calendar cal = Calendar.getInstance();
        cal.set(DefaultDecomposer.convertTwoDigitYear(year), month - 1, day, hour, minute, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }

    private static String getDeliveryReceiptValue(String attrName, String source) throws IndexOutOfBoundsException {
        String tmpAttr = attrName + ":";
        int startIndex = source.indexOf(tmpAttr);
        if (startIndex < 0) {
            return null;
        }
        int endIndex = source.indexOf(" ", startIndex += tmpAttr.length());
        if (endIndex > 0) {
            return source.substring(startIndex, endIndex);
        }
        return source.substring(startIndex);
    }

    private static String getDeliveryReceiptTextValue(String source) {
        String tmpAttr = "Text:";
        int startIndex = source.indexOf(tmpAttr);
        if (startIndex < 0) {
            tmpAttr = "Text".toLowerCase() + ":";
            startIndex = source.indexOf(tmpAttr);
        }
        if (startIndex < 0) {
            return null;
        }
        return source.substring(startIndex += tmpAttr.length());
    }

    private static void assignHeader(Command pdu, SequentialBytesReader seqBytesReader) {
        int commandLength = seqBytesReader.readInt();
        if (seqBytesReader.getBytes().length != commandLength) {
            logger.error("SYSTEM BUGS, the command_length (" + commandLength + ") not equals with the byte array length (" + seqBytesReader.getBytes().length + ")");
        }
        pdu.setCommandLength(commandLength);
        pdu.setCommandId(seqBytesReader.readInt());
        pdu.setCommandStatus(seqBytesReader.readInt());
        pdu.setSequenceNumber(seqBytesReader.readInt());
    }

    private static void assignHeader(Command pdu, byte[] bytes) {
        DefaultDecomposer.assignHeader(pdu, new SequentialBytesReader(bytes));
    }
}

