/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.util.CapacityPolicy;
import org.jsmpp.util.OctetUtil;
import org.jsmpp.util.SimpleCapacityPolicy;

public class PDUByteBuffer {
    private static CapacityPolicy DEFAULT_CAPACITY_POLICY = new SimpleCapacityPolicy();
    private CapacityPolicy capacityPolicy;
    private byte[] bytes = new byte[4];
    private int bytesLength;

    public PDUByteBuffer(int commandId, int commandStatus, int sequenceNumber) {
        this(commandId, commandStatus, sequenceNumber, DEFAULT_CAPACITY_POLICY);
    }

    public PDUByteBuffer(int commandId, int commandStatus, int sequenceNumber, CapacityPolicy capacityPolicy) {
        this(capacityPolicy);
        this.append(commandId);
        this.append(commandStatus);
        this.append(sequenceNumber);
        this.normalizeCommandLength();
    }

    public PDUByteBuffer() {
        this(DEFAULT_CAPACITY_POLICY);
    }

    public PDUByteBuffer(CapacityPolicy capacityPolicy) {
        this.capacityPolicy = capacityPolicy;
        this.bytesLength = 4;
        this.normalizeCommandLength();
    }

    public int append(byte[] b, int offset, int length) {
        int oldLength = this.bytesLength;
        this.bytesLength += length;
        int newCapacity = this.capacityPolicy.ensureCapacity(this.bytesLength, this.bytes.length);
        if (newCapacity > this.bytes.length) {
            byte[] newB = new byte[newCapacity];
            System.arraycopy(this.bytes, 0, newB, 0, this.bytes.length);
            this.bytes = newB;
        }
        System.arraycopy(b, offset, this.bytes, oldLength, length);
        this.normalizeCommandLength();
        return this.bytesLength;
    }

    public int append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public int append(byte b) {
        return this.append(new byte[]{b});
    }

    public int append(int intValue) {
        return this.append(OctetUtil.intToBytes(intValue));
    }

    public int append(String stringValue, boolean nullTerminated) {
        if (stringValue != null) {
            this.append(stringValue.getBytes());
        }
        if (nullTerminated) {
            this.append((byte)0);
        }
        return this.bytesLength;
    }

    public int append(String stringValue) {
        return this.append(stringValue, true);
    }

    public int append(OptionalParameter optionalParameter) {
        return this.append(optionalParameter.serialize());
    }

    public int appendAll(OptionalParameter[] optionalParameters) {
        int length = 0;
        for (OptionalParameter optionalParamameter : optionalParameters) {
            length += this.append(optionalParamameter);
        }
        return length;
    }

    private void normalizeCommandLength() {
        System.arraycopy(OctetUtil.intToBytes(this.bytesLength), 0, this.bytes, 0, 4);
    }

    public byte[] toBytes() {
        byte[] returnBytes = new byte[this.bytesLength];
        System.arraycopy(this.bytes, 0, returnBytes, 0, this.bytesLength);
        return returnBytes;
    }

    int getCommandLengthValue() {
        return OctetUtil.bytesToInt(this.bytes, 0);
    }

    int getBytesLength() {
        return this.bytesLength;
    }
}

