/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp;

import java.io.IOException;
import java.io.OutputStream;
import org.jsmpp.InvalidNumberOfDestinationsException;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;

public class DefaultPDUSender
implements PDUSender {
    private final PDUComposer pduComposer;

    public DefaultPDUSender() {
        this(new DefaultComposer());
    }

    public DefaultPDUSender(PDUComposer pduComposer) {
        this.pduComposer = pduComposer;
    }

    public byte[] sendHeader(OutputStream os, int commandId, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.composeHeader(commandId, commandStatus, sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendBind(OutputStream os, BindType bindType, int sequenceNumber, String systemId, String password, String systemType, InterfaceVersion interfaceVersion, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.bind(bindType.commandId(), sequenceNumber, systemId, password, systemType, interfaceVersion.value(), addrTon.value(), addrNpi.value(), addressRange);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendBindResp(OutputStream os, int commandId, int sequenceNumber, String systemId) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.bindResp(commandId, sequenceNumber, systemId, new OptionalParameter[0]);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendUnbind(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.unbind(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendGenericNack(OutputStream os, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.genericNack(commandStatus, sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendUnbindResp(OutputStream os, int commandStatus, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.unbindResp(commandStatus, sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendEnquireLink(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.enquireLink(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendEnquireLinkResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.enquireLinkResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendSubmitSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocoId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte replaceIfPresent, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.submitSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr, esmClass.value(), protocoId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery.value(), replaceIfPresent, dataCoding.value(), smDefaultMsgId, shortMessage, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendSubmitSmResp(OutputStream os, int sequenceNumber, String messageId) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.submitSmResp(sequenceNumber, messageId);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendQuerySm(OutputStream os, int sequenceNumber, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.querySm(sequenceNumber, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendQuerySmResp(OutputStream os, int sequenceNumber, String messageId, String finalDate, MessageState messageState, byte errorCode) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.querySmResp(sequenceNumber, messageId, finalDate, messageState.value(), errorCode);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendDeliverSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocoId, byte priorityFlag, RegisteredDelivery registeredDelivery, DataCoding dataCoding, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.deliverSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr, esmClass.value(), protocoId, priorityFlag, registeredDelivery.value(), dataCoding.value(), shortMessage, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendDeliverSmResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.deliverSmResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendDataSm(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, RegisteredDelivery registeredDelivery, DataCoding dataCoding, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.dataSm(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr, esmClass.value(), registeredDelivery.value(), dataCoding.value(), optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendDataSmResp(OutputStream os, int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.dataSmResp(sequenceNumber, messageId, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendCancelSm(OutputStream os, int sequenceNumber, String serviceType, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.cancelSm(sequenceNumber, serviceType, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destAddrTon.value(), destAddrNpi.value(), destinationAddr);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendCancelSmResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.cancelSmResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendReplaceSm(OutputStream os, int sequenceNumber, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte smDefaultMsgId, byte[] shortMessage) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.replaceSm(sequenceNumber, messageId, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, scheduleDeliveryTime, validityPeriod, registeredDelivery.value(), smDefaultMsgId, shortMessage);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendReplaceSmResp(OutputStream os, int sequenceNumber) throws IOException {
        byte[] b = this.pduComposer.replaceSmResp(sequenceNumber);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendSubmiMulti(OutputStream os, int sequenceNumber, String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, DestinationAddress[] destinationAddresses, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, ReplaceIfPresentFlag replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, InvalidNumberOfDestinationsException, IOException {
        byte[] b = this.pduComposer.submitMulti(sequenceNumber, serviceType, sourceAddrTon.value(), sourceAddrNpi.value(), sourceAddr, destinationAddresses, esmClass.value(), protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery.value(), replaceIfPresentFlag.value(), dataCoding.value(), smDefaultMsgId, shortMessage, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendSubmitMultiResp(OutputStream os, int sequenceNumber, String messageId, UnsuccessDelivery ... unsuccessDeliveries) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.submitMultiResp(sequenceNumber, messageId, unsuccessDeliveries);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    public byte[] sendAlertNotification(OutputStream os, int sequenceNumber, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, byte esmeAddrTon, byte esmeAddrNpi, String esmeAddr, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        byte[] b = this.pduComposer.alertNotification(sequenceNumber, sourceAddrTon, sourceAddrNpi, sourceAddr, esmeAddrTon, esmeAddrNpi, esmeAddr, optionalParameters);
        DefaultPDUSender.writeAndFlush(os, b);
        return b;
    }

    private static void writeAndFlush(OutputStream out, byte[] b) throws IOException {
        out.write(b);
        out.flush();
    }
}

