/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jsmpp.util.OctetUtil;

public abstract class OptionalParameter {
    public final short tag;

    public OptionalParameter(short tag) {
        this.tag = tag;
    }

    public byte[] serialize() {
        byte[] value = this.serializeValue();
        ByteBuffer buffer = ByteBuffer.allocate(value.length + 4);
        buffer.putShort(this.tag);
        buffer.putShort((short)value.length);
        buffer.put(value);
        return buffer.array();
    }

    protected abstract byte[] serializeValue();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tag;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OptionalParameter other = (OptionalParameter)obj;
        return this.tag == other.tag;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        DEST_ADDR_SUBUNIT(5, Byte.class),
        DEST_NETWORK_TYPE(6, Byte.class),
        DEST_BEARER_TYPE(7, Byte.class),
        DEST_TELEMATICS_ID(8, Short.class),
        SOURCE_ADDR_SUBUNIT(13, Byte.class),
        SOURCE_NETWORK_TYPE(14, Byte.class),
        SOURCE_BEARER_TYPE(15, Byte.class),
        SOURCE_TELEMATICS_ID(16, Byte.class),
        QOS_TIME_TO_LIVE(23, Int.class),
        PAYLOAD_TYPE(25, Byte.class),
        ADDITIONAL_STATUS_INFO_TEXT(29, COctetString.class),
        RECEIPTED_MESSAGE_ID(30, COctetString.class),
        MS_MSG_WAIT_FACILITIES(48, Byte.class),
        PRIVACY_INDICATOR(513, Byte.class),
        SOURCE_SUBADDRESS(514, OctetString.class),
        DEST_SUBADDRESS(515, OctetString.class),
        USER_MESSAGE_REFERENCE(516, Short.class),
        USER_RESPONSE_CODE(517, Byte.class),
        SOURCE_PORT(522, Short.class),
        DESTINATION_PORT(523, Short.class),
        SAR_MSG_REF_NUM(524, Short.class),
        LANGUAGE_INDICATOR(525, Byte.class),
        SAR_TOTAL_SEGMENTS(526, Byte.class),
        SAR_SEGMENT_SEQNUM(527, Byte.class),
        SC_INTERFACE_VERSION(528, Byte.class),
        CALLBACK_NUM_PRES_IND(770, Byte.class),
        CALLBACK_NUM_ATAG(771, OctetString.class),
        NUMBER_OF_MESSAGES(772, Byte.class),
        CALLBACK_NUM(897, OctetString.class),
        DPF_RESULT(1056, Byte.class),
        SET_DPF(1057, Byte.class),
        MS_AVAILABILITY_STATUS(1058, Byte.class),
        NETWORK_ERROR_CODE(1059, OctetString.class),
        MESSAGE_PAYLOAD(1060, OctetString.class),
        DELIVERY_FAILURE_REASON(1061, Byte.class),
        MORE_MESSAGES_TO_SEND(1062, Byte.class),
        MESSAGE_STATE(1063, Byte.class),
        USSD_SERVICE_OP(1281, Byte.class),
        DISPLAY_TIME(4609, Byte.class),
        SMS_SIGNAL(4611, Short.class),
        MS_VALIDITY(4612, Byte.class),
        ALERT_ON_MESSAGE_DELIVERY(4876, Null.class),
        ITS_REPLY_TYPE(4992, Byte.class),
        ITS_SESSION_INFO(4995, Short.class);

        private final short code;
        final Class<? extends OptionalParameter> type;

        private Tag(int code, Class<? extends OptionalParameter> type) {
            this.code = (short)code;
            this.type = type;
        }

        @Deprecated
        public short value() {
            return this.code;
        }

        public short code() {
            return this.code;
        }

        public static Tag valueOf(short code) {
            for (Tag tag : Tag.values()) {
                if (tag.code != code) continue;
                return tag;
            }
            throw new IllegalArgumentException("No tag for: " + code);
        }
    }

    public static class COctetString
    extends OctetString {
        public COctetString(short tag, String value, String charsetName) throws UnsupportedEncodingException {
            super(tag, value, charsetName);
        }

        public COctetString(short tag, String value) {
            super(tag, value);
        }

        public COctetString(short tag, byte[] value) {
            super(tag, value);
        }

        public String getValueAsString() {
            byte[] value = this.getValue();
            return new String(value, 0, value.length - 1);
        }
    }

    public static class OctetString
    extends OptionalParameter {
        private final byte[] value;

        public OctetString(short tag, String value) {
            super(tag);
            this.value = value.getBytes();
        }

        public OctetString(Tag tag, String value) {
            this(tag.code(), value);
        }

        public OctetString(short tag, String value, String charsetName) throws UnsupportedEncodingException {
            super(tag);
            this.value = value.getBytes(charsetName);
        }

        public OctetString(short tag, byte[] value) {
            super(tag);
            this.value = value;
        }

        public OctetString(short tag, byte[] value, int offset, int length) {
            super(tag);
            this.value = new byte[length];
            System.arraycopy(value, offset, this.value, offset, length);
        }

        public byte[] getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return new String(this.value);
        }

        protected byte[] serializeValue() {
            return this.value;
        }
    }

    public static class Byte
    extends OptionalParameter {
        private final byte value;

        public Byte(short tag, byte value) {
            super(tag);
            this.value = value;
        }

        public Byte(Tag tag, byte value) {
            this(tag.code(), value);
        }

        public Byte(short tag, byte[] content) {
            this(tag, content[0]);
        }

        public byte getValue() {
            return this.value;
        }

        protected byte[] serializeValue() {
            return new byte[]{this.value};
        }
    }

    public static class Int
    extends OptionalParameter {
        private final int value;

        public Int(short tag, int value) {
            super(tag);
            this.value = value;
        }

        public Int(Tag tag, int value) {
            this(tag.code(), value);
        }

        public Int(short tag, byte[] content) {
            this(tag, OctetUtil.bytesToInt(content));
        }

        public int getValue() {
            return this.value;
        }

        protected byte[] serializeValue() {
            return OctetUtil.intToBytes(this.value);
        }
    }

    public static class Short
    extends OptionalParameter {
        private final short value;

        public Short(short tag, short value) {
            super(tag);
            this.value = value;
        }

        public Short(Tag tag, short value) {
            this(tag.code(), value);
        }

        public Short(short tag, byte[] value) {
            this(tag, OctetUtil.bytesToShort(value));
        }

        public short getValue() {
            return this.value;
        }

        protected byte[] serializeValue() {
            return OctetUtil.shortToBytes(this.value);
        }
    }

    public static class Null
    extends OptionalParameter {
        public Null(short tag) {
            super(tag);
        }

        public Null(Tag tag) {
            this(tag.code());
        }

        protected byte[] serializeValue() {
            return new byte[0];
        }
    }
}

