/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.InvalidNumberOfDestinationsException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.DistributionList;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.UnsuccessDelivery;
import org.jsmpp.util.PDUByteBuffer;
import org.jsmpp.util.PDUComposer;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComposer
implements PDUComposer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultComposer.class);

    public byte[] composeHeader(int commandId, int commandStatus, int sequenceNumber) {
        PDUByteBuffer buf = new PDUByteBuffer(commandId, commandStatus, sequenceNumber);
        return buf.toBytes();
    }

    public byte[] bind(int commandId, int sequenceNumber, String systemId, String password, String systemType, byte interfaceVersion, byte addrTon, byte addrNpi, String addressRange) throws PDUStringException {
        StringValidator.validateString(systemId, StringParameter.SYSTEM_ID);
        StringValidator.validateString(password, StringParameter.PASSWORD);
        StringValidator.validateString(systemType, StringParameter.SYSTEM_TYPE);
        StringValidator.validateString(addressRange, StringParameter.ADDRESS_RANGE);
        PDUByteBuffer buf = new PDUByteBuffer(commandId, 0, sequenceNumber);
        buf.append(systemId);
        buf.append(password);
        buf.append(systemType);
        buf.append(interfaceVersion);
        buf.append(addrTon);
        buf.append(addrNpi);
        buf.append(addressRange);
        return buf.toBytes();
    }

    public byte[] bindResp(int commandId, int sequenceNumber, String systemId, OptionalParameter ... optionalParameters) throws PDUStringException {
        StringValidator.validateString(systemId, StringParameter.SYSTEM_ID);
        PDUByteBuffer buf = new PDUByteBuffer(commandId, 0, sequenceNumber);
        buf.append(systemId);
        buf.appendAll(optionalParameters);
        return buf.toBytes();
    }

    public byte[] bindResp(int commandId, int sequenceNumber, String systemId, byte scInterfaceVersion) throws PDUStringException {
        StringValidator.validateString(systemId, StringParameter.SYSTEM_ID);
        PDUByteBuffer buf = new PDUByteBuffer(commandId, 0, sequenceNumber);
        buf.append(systemId);
        OptionalParameter.Byte optParam = new OptionalParameter.Byte(OptionalParameter.Tag.SC_INTERFACE_VERSION, scInterfaceVersion);
        buf.append(optParam.serialize());
        return buf.toBytes();
    }

    public byte[] unbind(int sequenceNumber) {
        PDUByteBuffer buf = new PDUByteBuffer(6, 0, sequenceNumber);
        return buf.toBytes();
    }

    public byte[] unbindResp(int commandStatus, int sequenceNumber) {
        return this.composeHeader(-2147483642, commandStatus, sequenceNumber);
    }

    public byte[] outbind(int sequenceNumber, String systemId, String password) throws PDUStringException {
        StringValidator.validateString(systemId, StringParameter.SYSTEM_ID);
        StringValidator.validateString(password, StringParameter.PASSWORD);
        PDUByteBuffer buf = new PDUByteBuffer(11, 0, sequenceNumber);
        buf.append(systemId);
        buf.append(password);
        return buf.toBytes();
    }

    public byte[] enquireLink(int sequenceNumber) {
        return this.composeHeader(21, 0, sequenceNumber);
    }

    public byte[] enquireLinkResp(int sequenceNumber) {
        return this.composeHeader(-2147483627, 0, sequenceNumber);
    }

    public byte[] genericNack(int commandStatus, int sequenceNumber) {
        return this.composeHeader(Integer.MIN_VALUE, commandStatus, sequenceNumber);
    }

    public byte[] submitSm(int sequenceNumber, String serviceType, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, byte destAddrTon, byte destAddrNpi, String destinationAddr, byte esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, byte registeredDelivery, byte replaceIfPresentFlag, byte dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException {
        StringValidator.validateString(serviceType, StringParameter.SERVICE_TYPE);
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(destinationAddr, StringParameter.DESTINATION_ADDR);
        StringValidator.validateString(scheduleDeliveryTime, StringParameter.SCHEDULE_DELIVERY_TIME);
        StringValidator.validateString(validityPeriod, StringParameter.VALIDITY_PERIOD);
        StringValidator.validateString(shortMessage, StringParameter.SHORT_MESSAGE);
        PDUByteBuffer buf = new PDUByteBuffer(4, 0, sequenceNumber);
        buf.append(serviceType);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append(destAddrTon);
        buf.append(destAddrNpi);
        buf.append(destinationAddr);
        buf.append(esmClass);
        buf.append(protocolId);
        buf.append(priorityFlag);
        buf.append(scheduleDeliveryTime);
        buf.append(validityPeriod);
        buf.append(registeredDelivery);
        buf.append(replaceIfPresentFlag);
        buf.append(dataCoding);
        buf.append(smDefaultMsgId);
        buf.append((byte)shortMessage.length);
        buf.append(shortMessage);
        buf.appendAll(optionalParameters);
        return buf.toBytes();
    }

    public byte[] submitSmResp(int sequenceNumber, String messageId) throws PDUStringException {
        StringValidator.validateString(messageId, StringParameter.MESSAGE_ID);
        PDUByteBuffer buf = new PDUByteBuffer(-2147483644, 0, sequenceNumber);
        buf.append(messageId);
        return buf.toBytes();
    }

    public byte[] querySm(int sequenceNumber, String messageId, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr) throws PDUStringException {
        StringValidator.validateString(messageId, StringParameter.MESSAGE_ID);
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        PDUByteBuffer buf = new PDUByteBuffer(3, 0, sequenceNumber);
        buf.append(messageId);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        return buf.toBytes();
    }

    public byte[] querySmResp(int sequenceNumber, String messageId, String finalDate, byte messageState, byte errorCode) throws PDUStringException {
        StringValidator.validateString(messageId, StringParameter.MESSAGE_ID);
        StringValidator.validateString(finalDate, StringParameter.FINAL_DATE);
        PDUByteBuffer buf = new PDUByteBuffer(-2147483645, 0, sequenceNumber);
        buf.append(messageId);
        buf.append(finalDate);
        buf.append(messageState);
        buf.append(errorCode);
        return buf.toBytes();
    }

    public byte[] deliverSm(int sequenceNumber, String serviceType, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, byte destAddrTon, byte destAddrNpi, String destinationAddr, byte esmClass, byte protocolId, byte priorityFlag, byte registeredDelivery, byte dataCoding, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException {
        StringValidator.validateString(serviceType, StringParameter.SERVICE_TYPE);
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(destinationAddr, StringParameter.DESTINATION_ADDR);
        StringValidator.validateString(shortMessage, StringParameter.SHORT_MESSAGE);
        PDUByteBuffer buf = new PDUByteBuffer(5, 0, sequenceNumber);
        buf.append(serviceType);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append(destAddrTon);
        buf.append(destAddrNpi);
        buf.append(destinationAddr);
        buf.append(esmClass);
        buf.append(protocolId);
        buf.append(priorityFlag);
        buf.append((String)null);
        buf.append((String)null);
        buf.append(registeredDelivery);
        buf.append((byte)0);
        buf.append(dataCoding);
        buf.append((byte)0);
        buf.append((byte)shortMessage.length);
        buf.append(shortMessage);
        buf.appendAll(optionalParameters);
        return buf.toBytes();
    }

    public byte[] deliverSmResp(int sequenceNumber) {
        PDUByteBuffer buf = new PDUByteBuffer(-2147483643, 0, sequenceNumber);
        buf.append((String)null);
        return buf.toBytes();
    }

    public byte[] dataSm(int sequenceNumber, String serviceType, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, byte destAddrTon, byte destAddrNpi, String destinationAddr, byte esmClass, byte registeredDelivery, byte dataCoding, OptionalParameter ... optionalParameters) throws PDUStringException {
        StringValidator.validateString(serviceType, StringParameter.SERVICE_TYPE);
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(destinationAddr, StringParameter.DESTINATION_ADDR);
        PDUByteBuffer buf = new PDUByteBuffer(259, 0, sequenceNumber);
        buf.append(serviceType);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append(destAddrTon);
        buf.append(destAddrNpi);
        buf.append(destinationAddr);
        buf.append(esmClass);
        buf.append(registeredDelivery);
        buf.append(dataCoding);
        buf.appendAll(optionalParameters);
        return buf.toBytes();
    }

    public byte[] dataSmResp(int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException {
        StringValidator.validateString(messageId, StringParameter.MESSAGE_ID);
        PDUByteBuffer buf = new PDUByteBuffer(-2147483389, 0, sequenceNumber);
        buf.append(messageId);
        return buf.toBytes();
    }

    public byte[] cancelSm(int sequenceNumber, String serviceType, String messageId, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, byte destAddrTon, byte destAddrNpi, String destinationAddr) throws PDUStringException {
        StringValidator.validateString(serviceType, StringParameter.SERVICE_TYPE);
        StringValidator.validateString(messageId, StringParameter.MESSAGE_ID);
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(destinationAddr, StringParameter.DESTINATION_ADDR);
        PDUByteBuffer buf = new PDUByteBuffer(8, 0, sequenceNumber);
        buf.append(serviceType);
        buf.append(messageId);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append(destAddrTon);
        buf.append(destAddrNpi);
        buf.append(destinationAddr);
        return buf.toBytes();
    }

    public byte[] cancelSmResp(int sequenceNumber) {
        byte[] b = this.composeHeader(-2147483640, 0, sequenceNumber);
        return b;
    }

    public byte[] replaceSm(int sequenceNumber, String messageId, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, String scheduleDeliveryTime, String validityPeriod, byte registeredDelivery, byte smDefaultMsgId, byte[] shortMessage) throws PDUStringException {
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(scheduleDeliveryTime, StringParameter.SCHEDULE_DELIVERY_TIME);
        StringValidator.validateString(validityPeriod, StringParameter.VALIDITY_PERIOD);
        StringValidator.validateString(shortMessage, StringParameter.SHORT_MESSAGE);
        PDUByteBuffer buf = new PDUByteBuffer(7, 0, sequenceNumber);
        buf.append(messageId);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append(scheduleDeliveryTime);
        buf.append(validityPeriod);
        buf.append(registeredDelivery);
        buf.append(smDefaultMsgId);
        buf.append((byte)shortMessage.length);
        buf.append(shortMessage);
        return buf.toBytes();
    }

    public byte[] replaceSmResp(int sequenceNumber) {
        return this.composeHeader(-2147483641, 0, sequenceNumber);
    }

    public byte[] submitMulti(int sequenceNumber, String serviceType, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, DestinationAddress[] destinationAddresses, byte esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, byte registeredDelivery, byte replaceIfPresentFlag, byte dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUStringException, InvalidNumberOfDestinationsException {
        StringValidator.validateString(serviceType, StringParameter.SERVICE_TYPE);
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(scheduleDeliveryTime, StringParameter.SCHEDULE_DELIVERY_TIME);
        StringValidator.validateString(validityPeriod, StringParameter.VALIDITY_PERIOD);
        StringValidator.validateString(shortMessage, StringParameter.SHORT_MESSAGE);
        if (destinationAddresses.length > 255) {
            throw new InvalidNumberOfDestinationsException("Number of destination is invalid. Should be no more than 255. Actual number is " + destinationAddresses, destinationAddresses.length);
        }
        PDUByteBuffer buf = new PDUByteBuffer(33, 0, sequenceNumber);
        buf.append(serviceType);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append((byte)destinationAddresses.length);
        for (DestinationAddress destAddr : destinationAddresses) {
            buf.append(destAddr.getFlag().getValue());
            if (destAddr instanceof Address) {
                Address addr = (Address)destAddr;
                StringValidator.validateString(addr.getAddress(), StringParameter.DESTINATION_ADDR);
                buf.append(addr.getTon());
                buf.append(addr.getNpi());
                buf.append(addr.getAddress());
                continue;
            }
            if (destAddr instanceof DistributionList) {
                DistributionList dl = (DistributionList)destAddr;
                StringValidator.validateString(dl.getName(), StringParameter.DL_NAME);
                continue;
            }
            logger.warn("Unknown destination address flag: " + destAddr.getClass());
        }
        buf.append(esmClass);
        buf.append(protocolId);
        buf.append(priorityFlag);
        buf.append(scheduleDeliveryTime);
        buf.append(validityPeriod);
        buf.append(registeredDelivery);
        buf.append(replaceIfPresentFlag);
        buf.append(dataCoding);
        buf.append(smDefaultMsgId);
        buf.append((byte)shortMessage.length);
        buf.append(shortMessage);
        buf.appendAll(optionalParameters);
        return buf.toBytes();
    }

    public byte[] submitMultiResp(int sequenceNumber, String messageId, UnsuccessDelivery ... unsuccessDeliveries) throws PDUStringException {
        StringValidator.validateString(messageId, StringParameter.MESSAGE_ID);
        PDUByteBuffer buf = new PDUByteBuffer(-2147483615, 0, sequenceNumber);
        buf.append(messageId);
        buf.append((byte)unsuccessDeliveries.length);
        for (UnsuccessDelivery delivery : unsuccessDeliveries) {
            StringValidator.validateString(delivery.getDestinationAddress().getAddress(), StringParameter.DESTINATION_ADDR);
            Address destAddr = delivery.getDestinationAddress();
            buf.append(destAddr.getTon());
            buf.append(destAddr.getNpi());
            buf.append(destAddr.getAddress());
            buf.append(delivery.getErrorStatusCode());
        }
        return buf.toBytes();
    }

    public byte[] alertNotification(int sequenceNumber, byte sourceAddrTon, byte sourceAddrNpi, String sourceAddr, byte esmeAddrTon, byte esmeAddrNpi, String esmeAddr, OptionalParameter ... optionalParameters) throws PDUStringException {
        StringValidator.validateString(sourceAddr, StringParameter.SOURCE_ADDR);
        StringValidator.validateString(esmeAddr, StringParameter.ESME_ADDR);
        PDUByteBuffer buf = new PDUByteBuffer(258, 0, sequenceNumber);
        buf.append(sourceAddrTon);
        buf.append(sourceAddrNpi);
        buf.append(sourceAddr);
        buf.append(esmeAddrTon);
        buf.append(esmeAddrNpi);
        buf.append(esmeAddr);
        buf.appendAll(optionalParameters);
        return buf.toBytes();
    }
}

