/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.snmp.util;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.servicemix.snmp.util.OIDList;
import org.snmp4j.smi.OID;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class OIDListEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        OIDList list;
        block18: {
            list = new OIDList();
            if (text.indexOf(",") != -1) {
                StringTokenizer strTok = new StringTokenizer(text, ",");
                while (strTok.hasMoreTokens()) {
                    String tok = strTok.nextToken();
                    if (tok == null || tok.trim().length() <= 0) continue;
                    list.add(new OID(tok.trim()));
                }
            } else {
                if (text.indexOf(":") != -1) {
                    try {
                        DefaultResourceLoader loader = new DefaultResourceLoader();
                        Resource file = loader.getResource(text);
                        if (file.exists()) {
                            BufferedReader br = null;
                            try {
                                br = new BufferedReader(new FileReader(file.getFile()));
                                String line = null;
                                while ((line = br.readLine()) != null) {
                                    list.add(new OID(line.trim()));
                                }
                                break block18;
                            }
                            catch (IOException ex) {
                                throw new IllegalArgumentException(text + " is not a valid argument.", ex);
                            }
                            finally {
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (IOException ex) {}
                                }
                            }
                        }
                        throw new IllegalArgumentException(text + " is not a valid argument.");
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException(text + " is not a valid argument.", ex);
                    }
                }
                list.add(new OID(text.trim()));
            }
        }
        this.setValue(list);
    }
}

