/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OctetString;

public abstract class PrivAES
implements PrivacyProtocol {
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    private static final LogAdapter logger = LogFactory.getLogger(PrivAES.class);
    private int keyBytes;
    protected Salt salt;

    public PrivAES(int n) {
        if (n != 16 && n != 24 && n != 32) {
            throw new IllegalArgumentException("Only 128, 192 and 256 bit AES is allowed. Requested (" + 8 * n + ").");
        }
        this.keyBytes = n;
        this.salt = Salt.getInstance();
    }

    public byte[] encrypt(byte[] byArray, int n, int n2, byte[] byArray2, long l, long l2, DecryptParams decryptParams) {
        byte[] byArray3 = new byte[16];
        long l3 = this.salt.getNext();
        if (byArray2.length < this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got only " + byArray2.length + ".");
        }
        if (decryptParams.array == null || decryptParams.length < 8) {
            decryptParams.array = new byte[8];
        }
        decryptParams.length = 8;
        decryptParams.offset = 0;
        byArray3[0] = (byte)(l >> 24 & 0xFFL);
        byArray3[1] = (byte)(l >> 16 & 0xFFL);
        byArray3[2] = (byte)(l >> 8 & 0xFFL);
        byArray3[3] = (byte)(l & 0xFFL);
        byArray3[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray3[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray3[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray3[7] = (byte)(l2 & 0xFFL);
        int n3 = 56;
        int n4 = 8;
        while (n3 >= 0) {
            byArray3[n4] = (byte)(l3 >> n3 & 0xFFL);
            n3 -= 8;
            ++n4;
        }
        for (n3 = 0; n3 < 8; ++n3) {
            decryptParams.array[n3] = byArray3[n3 + 8];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initVect is " + PrivAES.asHex(byArray3));
        }
        byte[] byArray4 = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, this.keyBytes, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            byArray4 = cipher.doFinal(byArray, n, n2);
            if (logger.isDebugEnabled()) {
                logger.debug("aes encrypt: Data to encrypt " + PrivAES.asHex(byArray));
                logger.debug("aes encrypt: used key " + PrivAES.asHex(byArray2));
                logger.debug("aes encrypt: created privacy_params " + PrivAES.asHex(decryptParams.array));
                logger.debug("aes encrypt: encrypted Data  " + PrivAES.asHex(byArray4));
            }
        }
        catch (Exception exception) {
            logger.error("Encrypt Exception " + exception);
        }
        return byArray4;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, byte[] byArray2, long l, long l2, DecryptParams decryptParams) {
        byte[] byArray3 = new byte[16];
        if (byArray2.length < this.keyBytes) {
            throw new IllegalArgumentException("Needed key length is " + this.keyBytes + ". Got only " + byArray2.length + ".");
        }
        byArray3[0] = (byte)(l >> 24 & 0xFFL);
        byArray3[1] = (byte)(l >> 16 & 0xFFL);
        byArray3[2] = (byte)(l >> 8 & 0xFFL);
        byArray3[3] = (byte)(l & 0xFFL);
        byArray3[4] = (byte)(l2 >> 24 & 0xFFL);
        byArray3[5] = (byte)(l2 >> 16 & 0xFFL);
        byArray3[6] = (byte)(l2 >> 8 & 0xFFL);
        byArray3[7] = (byte)(l2 & 0xFFL);
        for (int i = 0; i < 8; ++i) {
            byArray3[i + 8] = decryptParams.array[i + decryptParams.offset];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("initVect is " + PrivAES.asHex(byArray3));
        }
        byte[] byArray4 = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, this.keyBytes, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byArray4 = cipher.doFinal(byArray, n, n2);
            if (logger.isDebugEnabled()) {
                logger.debug("aes decrypt: Data to decrypt " + PrivAES.asHex(byArray));
                logger.debug("aes decrypt: used key " + PrivAES.asHex(byArray2));
                logger.debug("aes decrypt: used privacy_params " + PrivAES.asHex(decryptParams.array));
                logger.debug("aes decrypt: decrypted Data  " + PrivAES.asHex(byArray4));
            }
        }
        catch (Exception exception) {
            logger.error("Decrypt Exception " + exception);
        }
        return byArray4;
    }

    public int getEncryptedLength(int n) {
        return n;
    }

    public static String asHex(byte[] byArray) {
        return new OctetString(byArray).toHexString();
    }

    public int getMinKeyLength() {
        return this.keyBytes;
    }

    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }

    public int getDecryptParamsLength() {
        return 8;
    }
}

