/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.UdpTransportMapping;

public class DefaultUdpTransportMapping
extends UdpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultUdpTransportMapping.class);
    protected DatagramSocket socket = null;
    protected ListenThread listener;
    private int socketTimeout = 1000;
    private int receiveBufferSize = 0;

    public DefaultUdpTransportMapping() throws IOException {
        super(new UdpAddress(InetAddress.getLocalHost(), 0));
        this.socket = new DatagramSocket(this.udpAddress.getPort());
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress, boolean bl) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(null);
        this.socket.setReuseAddress(bl);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(udpAddress.getInetAddress(), udpAddress.getPort());
        this.socket.bind(inetSocketAddress);
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(udpAddress.getPort(), udpAddress.getInetAddress());
    }

    public void sendMessage(Address address, byte[] byArray) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(((UdpAddress)address).getInetAddress(), ((UdpAddress)address).getPort());
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message to " + address + " with length " + byArray.length + ": " + new OctetString(byArray).toHexString());
        }
        this.socket.send(new DatagramPacket(byArray, byArray.length, inetSocketAddress));
    }

    public void close() throws IOException {
        ListenThread listenThread = this.listener;
        if (listenThread != null) {
            listenThread.close();
            listenThread.interrupt();
            if (this.socketTimeout > 0) {
                try {
                    listenThread.join();
                }
                catch (InterruptedException interruptedException) {
                    logger.warn(interruptedException);
                }
            }
            this.listener = null;
        }
        if (!this.socket.isClosed()) {
            this.socket.disconnect();
            this.socket.close();
        }
    }

    public synchronized void listen() throws IOException {
        if (this.listener != null) {
            throw new SocketException("Port already listening");
        }
        this.listener = new ListenThread();
        this.listener.setDaemon(true);
        this.listener.start();
    }

    public void setPriority(int n) {
        ListenThread listenThread = this.listener;
        if (listenThread != null) {
            listenThread.setPriority(n);
        }
    }

    public int getPriority() {
        ListenThread listenThread = this.listener;
        if (listenThread != null) {
            return listenThread.getPriority();
        }
        return 5;
    }

    public void setThreadName(String string) {
        ListenThread listenThread = this.listener;
        if (listenThread != null) {
            listenThread.setName(string);
        }
    }

    public String getThreadName() {
        ListenThread listenThread = this.listener;
        if (listenThread != null) {
            return listenThread.getName();
        }
        return null;
    }

    public void setMaxInboundMessageSize(int n) {
        this.maxInboundMessageSize = n;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = n;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public boolean isListening() {
        return this.listener != null;
    }

    class ListenThread
    extends Thread {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() throws SocketException {
            this.buf = new byte[DefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
            this.setName("DefaultUDPTransportMapping_" + DefaultUdpTransportMapping.this.getAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                DefaultUdpTransportMapping.this.socket.setSoTimeout(DefaultUdpTransportMapping.this.getSocketTimeout());
                if (DefaultUdpTransportMapping.this.receiveBufferSize > 0) {
                    DefaultUdpTransportMapping.this.socket.setReceiveBufferSize(Math.max(DefaultUdpTransportMapping.this.receiveBufferSize, DefaultUdpTransportMapping.this.maxInboundMessageSize));
                }
                if (logger.isInfoEnabled()) {
                    logger.info("UDP receive buffer size for socket " + DefaultUdpTransportMapping.this.getAddress() + " is set to: " + DefaultUdpTransportMapping.this.socket.getReceiveBufferSize());
                }
            }
            catch (SocketException socketException) {
                logger.error(socketException);
                DefaultUdpTransportMapping.this.setSocketTimeout(0);
            }
            while (!this.stop) {
                Object object2;
                object = new DatagramPacket(this.buf, this.buf.length, DefaultUdpTransportMapping.this.udpAddress.getInetAddress(), DefaultUdpTransportMapping.this.udpAddress.getPort());
                try {
                    ByteBuffer byteBuffer;
                    DefaultUdpTransportMapping.this.socket.receive((DatagramPacket)object);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received message from " + ((DatagramPacket)object).getAddress() + "/" + ((DatagramPacket)object).getPort() + " with length " + ((DatagramPacket)object).getLength() + ": " + new OctetString(((DatagramPacket)object).getData(), 0, ((DatagramPacket)object).getLength()).toHexString());
                    }
                    if (DefaultUdpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                        object2 = new byte[((DatagramPacket)object).getLength()];
                        System.arraycopy(((DatagramPacket)object).getData(), 0, object2, 0, ((Object)object2).length);
                        byteBuffer = ByteBuffer.wrap((byte[])object2);
                    } else {
                        byteBuffer = ByteBuffer.wrap(((DatagramPacket)object).getData());
                    }
                    DefaultUdpTransportMapping.this.fireProcessMessage(new UdpAddress(((DatagramPacket)object).getAddress(), ((DatagramPacket)object).getPort()), byteBuffer);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (PortUnreachableException portUnreachableException) {
                    object2 = DefaultUdpTransportMapping.this;
                    synchronized (object2) {
                        DefaultUdpTransportMapping.this.listener = null;
                    }
                    logger.error(portUnreachableException);
                    if (logger.isDebugEnabled()) {
                        portUnreachableException.printStackTrace();
                    }
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) break;
                    throw new RuntimeException(portUnreachableException);
                }
                catch (IOException iOException) {
                    logger.warn(iOException);
                    if (logger.isDebugEnabled()) {
                        iOException.printStackTrace();
                    }
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                    throw new RuntimeException(iOException);
                }
            }
            object = DefaultUdpTransportMapping.this;
            synchronized (object) {
                DefaultUdpTransportMapping.this.listener = null;
                this.stop = true;
                DefaultUdpTransportMapping.this.socket.close();
            }
        }

        public void close() {
            this.stop = true;
        }
    }
}

