/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.smi.OctetString;

public abstract class AuthGeneric
implements AuthenticationProtocol {
    private static final LogAdapter logger = LogFactory.getLogger(AuthGeneric.class);
    private int digestLength;
    private String protoName;

    public AuthGeneric(String string, int n) {
        this.protoName = string;
        this.digestLength = n;
    }

    public int getDigestLength() {
        return this.digestLength;
    }

    protected MessageDigest getDigestObject() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(this.protoName);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(this.protoName + " not supported in this VM.");
        }
        return messageDigest;
    }

    public boolean authenticate(byte[] byArray, byte[] byArray2, int n, int n2, ByteArrayWindow byteArrayWindow) {
        int n3;
        MessageDigest messageDigest = this.getDigestObject();
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[64];
        for (n3 = 0; n3 < 12; ++n3) {
            byteArrayWindow.set(n3, (byte)0);
        }
        for (n3 = 0; n3 < byArray.length; ++n3) {
            byArray3[n3] = (byte)(byArray[n3] ^ 0x36);
            byArray4[n3] = (byte)(byArray[n3] ^ 0x5C);
        }
        for (n3 = byArray.length; n3 < 64; ++n3) {
            byArray3[n3] = 54;
            byArray4[n3] = 92;
        }
        messageDigest.update(byArray3);
        messageDigest.update(byArray2, n, n2);
        byte[] byArray5 = messageDigest.digest();
        messageDigest.reset();
        messageDigest.update(byArray4);
        messageDigest.update(byArray5);
        byArray5 = messageDigest.digest();
        for (n3 = 0; n3 < 12; ++n3) {
            byteArrayWindow.set(n3, byArray5[n3]);
        }
        return true;
    }

    public boolean isAuthentic(byte[] byArray, byte[] byArray2, int n, int n2, ByteArrayWindow byteArrayWindow) {
        ByteArrayWindow byteArrayWindow2 = new ByteArrayWindow(new byte[12], 0, 12);
        System.arraycopy(byteArrayWindow.getValue(), byteArrayWindow.getOffset(), byteArrayWindow2.getValue(), 0, 12);
        if (!this.authenticate(byArray, byArray2, n, n2, byteArrayWindow)) {
            return false;
        }
        return byteArrayWindow.equals(byteArrayWindow2, 12);
    }

    public byte[] changeDelta(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        MessageDigest messageDigest = this.getDigestObject();
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "oldKey: " + new OctetString(byArray).toHexString());
            logger.debug(this.protoName + "newKey: " + new OctetString(byArray2).toHexString());
            logger.debug(this.protoName + "random: " + new OctetString(byArray3).toHexString());
        }
        messageDigest.update(byArray);
        messageDigest.update(byArray3);
        byte[] byArray4 = messageDigest.digest();
        byte[] byArray5 = new byte[byArray3.length + byArray2.length];
        for (n = 0; n < byArray3.length; ++n) {
            byArray5[n] = byArray3[n];
        }
        for (n = byArray3.length; n < byArray3.length + byArray2.length; ++n) {
            byArray5[n] = byArray2[n - byArray3.length];
        }
        for (n = byArray.length; n < byArray5.length; ++n) {
            int n2 = n;
            byArray5[n2] = (byte)(byArray5[n2] ^ byArray4[n - byArray.length]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "keyChange:" + new OctetString(byArray5).toHexString());
        }
        return byArray5;
    }

    public byte[] passwordToKey(OctetString octetString, byte[] byArray) {
        MessageDigest messageDigest = this.getDigestObject();
        byte[] byArray2 = new byte[64];
        int n = 0;
        byte[] byArray3 = octetString.getValue();
        for (int i = 0; i < 0x100000; i += 64) {
            for (int j = 0; j < 64; ++j) {
                byArray2[j] = byArray3[n++ % byArray3.length];
            }
            messageDigest.update(byArray2);
        }
        byte[] byArray4 = messageDigest.digest();
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "First digest: " + new OctetString(byArray4).toHexString());
        }
        messageDigest.reset();
        messageDigest.update(byArray4);
        messageDigest.update(byArray);
        messageDigest.update(byArray4);
        byArray4 = messageDigest.digest();
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "localized key: " + new OctetString(byArray4).toHexString());
        }
        return byArray4;
    }

    public byte[] hash(byte[] byArray) {
        MessageDigest messageDigest = this.getDigestObject();
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public byte[] hash(byte[] byArray, int n, int n2) {
        MessageDigest messageDigest = this.getDigestObject();
        messageDigest.update(byArray, n, n2);
        return messageDigest.digest();
    }
}

