/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.marshalers;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.W3CDOMStreamReader;
import org.apache.servicemix.jbi.jaxp.XMLStreamHelper;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.marshalers.SoapMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SoapWriter {
    public static final String SOAP_PART_ID = "soap-request";
    private SoapMessage message;
    private String contentType;
    private SoapMarshaler marshaler;
    private MimeMultipart parts;

    public SoapWriter(SoapMarshaler marshaler, SoapMessage message) {
        this.marshaler = marshaler;
        this.message = message;
        this.contentType = this.prepare();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void write(OutputStream out) throws Exception {
        if (this.message.hasAttachments()) {
            this.writeMultipartMessage(out);
        } else {
            this.writeSimpleMessage(out);
        }
    }

    private String prepare() {
        if (this.message.hasAttachments()) {
            this.parts = new MimeMultipart("related; type=\"text/xml\"; start=\"<soap-request>\"");
            return this.parts.getContentType();
        }
        return "text/xml;charset=" + SourceTransformer.getDefaultCharset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSimpleMessage(OutputStream out) throws Exception {
        if (this.message.getDocument() != null) {
            this.marshaler.getSourceTransformer().toResult((Source)new DOMSource(this.message.getDocument()), (Result)new StreamResult(out));
            return;
        }
        XMLStreamWriter writer = this.marshaler.getOutputFactory().createXMLStreamWriter(out, SourceTransformer.getDefaultCharset());
        writer.writeStartDocument();
        if (this.marshaler.isSoap()) {
            this.writeSoapEnvelope(writer);
        } else {
            if (this.message.hasHeaders()) {
                throw new IllegalStateException("SOAP headers found on non-soap message");
            }
            if (this.message.getFault() != null) {
                if (this.message.getFault().getDetails() == null) throw new IllegalStateException("Cannot write non xml faults for non soap messages");
                XMLStreamReader reader = this.marshaler.getSourceTransformer().toXMLStreamReader(this.message.getFault().getDetails());
                XMLStreamHelper.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
            } else if (this.message.getSource() != null) {
                this.writeContents(writer);
            }
        }
        writer.writeEndDocument();
        writer.flush();
    }

    private void writeMultipartMessage(OutputStream out) throws Exception {
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage mime = new MimeMessage(session);
        MimeBodyPart soapPart = new MimeBodyPart();
        soapPart.setContentID("<soap-request>");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeSimpleMessage(baos);
        soapPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(baos.toByteArray(), "text/xml")));
        soapPart.addHeader("Content-Transfer-Encoding", "8bit");
        this.parts.addBodyPart((BodyPart)soapPart);
        for (Map.Entry entry : this.message.getAttachments().entrySet()) {
            String id = (String)entry.getKey();
            DataHandler dh = (DataHandler)entry.getValue();
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(dh);
            part.setContentID("<" + id + ">");
            String encodingType = MimeUtility.getEncoding((DataHandler)dh);
            if ("7bit".equals(encodingType)) {
                encodingType = "8bit";
            }
            part.addHeader("Content-Transfer-Encoding", encodingType);
            this.parts.addBodyPart((BodyPart)part);
        }
        mime.setContent((Multipart)this.parts);
        mime.setHeader("Content-Type", this.getContentType());
        mime.saveChanges();
        Enumeration headersEnum = mime.getAllHeaders();
        ArrayList<String> headersList = new ArrayList<String>();
        while (headersEnum.hasMoreElements()) {
            headersList.add(((Header)headersEnum.nextElement()).getName().toLowerCase());
        }
        String[] headers = headersList.toArray(new String[0]);
        FilterOutputStream os = new FilterOutputStream(out){
            private int nb;
            {
                this.nb = 0;
            }

            public void write(int b) throws IOException {
                if (++this.nb > 2) {
                    super.write(b);
                }
            }
        };
        mime.writeTo((OutputStream)os, headers);
    }

    public void writeSoapEnvelope(XMLStreamWriter writer) throws Exception {
        QName envelope = this.getEnvelopeName();
        String soapUri = envelope.getNamespaceURI();
        String soapPrefix = envelope.getPrefix();
        writer.setPrefix(soapPrefix, soapUri);
        writer.writeStartElement(soapPrefix, "Envelope", soapUri);
        if (!this.marshaler.isRepairingNamespace()) {
            writer.writeNamespace(soapPrefix, soapUri);
        }
        if (this.message.getHeaders() != null && this.message.getHeaders().size() > 0) {
            writer.writeStartElement(soapPrefix, "Header", soapUri);
            for (DocumentFragment df : this.message.getHeaders().values()) {
                Element e = (Element)df.getFirstChild();
                XMLStreamHelper.copy((XMLStreamReader)new W3CDOMStreamReader(e), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        writer.writeStartElement(soapPrefix, "Body", soapUri);
        if (this.message.getFault() != null) {
            this.writeFault(writer);
        } else if (this.message.getSource() != null) {
            this.writeContents(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeContents(XMLStreamWriter writer) throws Exception {
        XMLStreamReader reader = this.marshaler.getSourceTransformer().toXMLStreamReader(this.message.getSource());
        XMLStreamHelper.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
    }

    private void writeFault(XMLStreamWriter writer) throws Exception {
        QName envelope = this.getEnvelopeName();
        String soapUri = envelope.getNamespaceURI();
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapUri)) {
            this.writeSoap11Fault(writer);
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(soapUri)) {
            this.writeSoap12Fault(writer);
        } else {
            throw new IllegalStateException("Unknown soap namespace: " + soapUri);
        }
    }

    private void writeSoap11Fault(XMLStreamWriter writer) throws Exception {
        Source details;
        String reason;
        QName envelope = this.getEnvelopeName();
        String soapUri = envelope.getNamespaceURI();
        String soapPrefix = envelope.getPrefix();
        writer.setPrefix(soapPrefix, soapUri);
        SoapFault fault = this.message.getFault();
        fault.translateCodeTo11();
        writer.writeStartElement(soapPrefix, "Fault", soapUri);
        QName code = fault.getCode();
        if (code != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_11_FAULTCODE);
            XMLStreamHelper.writeTextQName((XMLStreamWriter)writer, (QName)code);
            writer.writeEndElement();
        }
        if ((reason = fault.getReason()) == null && fault.getCause() != null) {
            reason = fault.getCause().toString();
        }
        XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_11_FAULTSTRING);
        if (reason != null) {
            writer.writeCharacters(reason);
        }
        writer.writeEndElement();
        URI node = fault.getNode();
        if (node != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_11_FAULTACTOR);
            writer.writeCharacters(node.toString());
            writer.writeEndElement();
        }
        if ((details = fault.getDetails()) != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_11_FAULTDETAIL);
            this.writeDetails(writer, details);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeSoap12Fault(XMLStreamWriter writer) throws Exception {
        Source details;
        URI role;
        String reason;
        QName envelope = this.getEnvelopeName();
        String soapUri = envelope.getNamespaceURI();
        String soapPrefix = envelope.getPrefix();
        writer.setPrefix(soapPrefix, soapUri);
        SoapFault fault = this.message.getFault();
        fault.translateCodeTo12();
        writer.writeStartElement(soapPrefix, "Fault", soapUri);
        QName code = fault.getCode();
        if (code != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTCODE);
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTVALUE);
            XMLStreamHelper.writeTextQName((XMLStreamWriter)writer, (QName)code);
            writer.writeEndElement();
            QName subcode = fault.getSubcode();
            if (subcode != null) {
                XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTSUBCODE);
                XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTVALUE);
                XMLStreamHelper.writeTextQName((XMLStreamWriter)writer, (QName)subcode);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if ((reason = fault.getReason()) == null && fault.getCause() != null) {
            reason = fault.getCause().toString();
        }
        XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTREASON);
        XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTTEXT);
        writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", "en");
        if (reason != null) {
            writer.writeCharacters(reason);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        URI node = fault.getNode();
        if (node != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTNODE);
            writer.writeCharacters(node.toString());
            writer.writeEndElement();
        }
        if ((role = fault.getRole()) != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTROLE);
            writer.writeCharacters(role.toString());
            writer.writeEndElement();
        }
        if ((details = fault.getDetails()) != null) {
            XMLStreamHelper.writeStartElement((XMLStreamWriter)writer, (QName)SoapMarshaler.SOAP_12_FAULTDETAIL);
            this.writeDetails(writer, details);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeDetails(XMLStreamWriter writer, Source details) throws ParserConfigurationException, IOException, SAXException, TransformerException, XMLStreamException {
        SourceTransformer st = new SourceTransformer();
        DOMSource domDetails = st.toDOMSource(details);
        Node detailsNode = domDetails.getNode().getFirstChild();
        if ("multiple-details".equals(detailsNode.getNodeName())) {
            NodeList children = detailsNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() != 1) continue;
                XMLStreamReader reader = this.marshaler.getSourceTransformer().toXMLStreamReader((Source)new DOMSource(node));
                XMLStreamHelper.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
            }
        } else {
            XMLStreamReader reader = this.marshaler.getSourceTransformer().toXMLStreamReader((Source)domDetails);
            XMLStreamHelper.copy((XMLStreamReader)reader, (XMLStreamWriter)writer);
        }
    }

    protected QName getEnvelopeName() {
        QName name = this.message.getEnvelopeName();
        if (name == null) {
            name = new QName(this.marshaler.getSoapUri(), "Envelope", this.marshaler.getPrefix());
        } else if (name.getPrefix() == null) {
            name = new QName(name.getNamespaceURI(), name.getLocalPart(), this.marshaler.getPrefix());
        }
        return name;
    }
}

