/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.security;

import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.auth.callback.CallbackHandler;
import org.apache.servicemix.common.security.KeystoreInstance;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.soap.handlers.security.BaseCrypto;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CryptoType;

public class KeystoreInstanceCrypto
extends BaseCrypto {
    private KeystoreInstance keystore;

    public KeystoreInstanceCrypto() {
    }

    public KeystoreInstanceCrypto(KeystoreInstance keystore) {
        this.keystore = keystore;
    }

    public KeystoreInstanceCrypto(KeystoreManager keystoreManager, String keystore) {
        this.keystore = keystoreManager.getKeystore(keystore);
    }

    public KeystoreInstance getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeystoreInstance keystore) {
        this.keystore = keystore;
    }

    protected String[] getAliases() throws KeyStoreException {
        String[] pks = this.keystore.listPrivateKeys();
        String[] tcs = this.keystore.listTrustCertificates();
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.addAll(Arrays.asList(pks));
        aliases.addAll(Arrays.asList(tcs));
        return aliases.toArray(new String[aliases.size()]);
    }

    protected Certificate getCertificate(String alias) throws KeyStoreException {
        return this.keystore.getCertificate(alias);
    }

    protected String getCertificateAlias(Certificate cert) throws KeyStoreException {
        return this.keystore.getCertificateAlias(cert);
    }

    protected Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.keystore.getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias, String password) throws WSSecurityException {
        return this.keystore.getPrivateKey(alias);
    }

    protected String[] getTrustCertificates() throws KeyStoreException {
        return this.keystore.listTrustCertificates();
    }

    public String getCryptoProvider() {
        return null;
    }

    public void setCryptoProvider(String provider) {
    }

    public String getDefaultX509Identifier() throws WSSecurityException {
        return null;
    }

    public void setDefaultX509Identifier(String identifier) {
    }

    public void setCertificateFactory(String provider, CertificateFactory certFactory) {
    }

    public byte[] getBytesFromCertificates(X509Certificate[] certs) throws WSSecurityException {
        return null;
    }

    public X509Certificate[] getCertificatesFromBytes(byte[] data) throws WSSecurityException {
        return null;
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        return null;
    }

    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        return null;
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        return null;
    }

    public boolean verifyTrust(X509Certificate[] certs) throws WSSecurityException {
        return false;
    }

    public boolean verifyTrust(PublicKey publicKey) throws WSSecurityException {
        return false;
    }

    public boolean verifyTrust(X509Certificate[] arg0, boolean arg1) throws WSSecurityException {
        return false;
    }
}

