/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.jaxp.W3CDOMStreamWriter;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.Handler;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.marshalers.JBIMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapWriter;
import org.w3c.dom.Document;

public class SoapHelper {
    private static final Log logger = LogFactory.getLog(SoapHelper.class);
    public static final URI IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OUT = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final URI ROBUST_IN_ONLY = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    private SoapEndpoint endpoint;
    private List policies;
    private JBIMarshaler jbiMarshaler;
    private SoapMarshaler soapMarshaler;
    private Map definitions;
    private Map operationNames;

    public SoapHelper(SoapEndpoint endpoint) {
        this.policies = endpoint.getPolicies();
        if (this.policies == null) {
            this.policies = Collections.EMPTY_LIST;
        }
        this.definitions = new HashMap();
        this.operationNames = new HashMap();
        this.jbiMarshaler = new JBIMarshaler();
        this.endpoint = endpoint;
        boolean requireDom = false;
        for (Handler handler : this.policies) {
            requireDom |= handler.requireDOM();
        }
        this.soapMarshaler = new SoapMarshaler(endpoint.isSoap(), requireDom);
        if (endpoint.isSoap() && "1.1".equals(endpoint.getSoapVersion())) {
            this.soapMarshaler.setSoapUri("http://schemas.xmlsoap.org/soap/envelope/");
        }
    }

    public SoapMarshaler getSoapMarshaler() {
        return this.soapMarshaler;
    }

    public JBIMarshaler getJBIMarshaler() {
        return this.jbiMarshaler;
    }

    public MessageExchange onReceive(Context context) throws Exception {
        String endpointName;
        QName serviceName;
        ComponentContext componentContext;
        ServiceEndpoint se;
        if (this.policies != null) {
            for (Handler policy : this.policies) {
                policy.onReceive(context);
            }
        }
        if (context.getProperty("org.apache.servicemix.Service") == null && context.getProperty("org.apache.servicemix.Interface") == null) {
            if (this.endpoint.getTargetInterfaceName() == null && this.endpoint.getTargetService() == null && this.endpoint.getTargetEndpoint() == null) {
                context.setProperty("org.apache.servicemix.Interface", this.endpoint.getInterfaceName());
                context.setProperty("org.apache.servicemix.Service", this.endpoint.getService());
                context.setProperty("org.apache.servicemix.Endpoint", this.endpoint.getEndpoint());
            } else {
                context.setProperty("org.apache.servicemix.Interface", this.endpoint.getTargetInterfaceName());
                context.setProperty("org.apache.servicemix.Service", this.endpoint.getTargetService());
                context.setProperty("org.apache.servicemix.Endpoint", this.endpoint.getTargetEndpoint());
            }
        }
        Operation operation = this.findOperation(context);
        if (context.getProperty("org.apache.servicemix.Operation") == null) {
            if (operation != null) {
                context.setProperty("org.apache.servicemix.Operation", this.operationNames.get(operation));
            } else if (this.endpoint.getDefaultOperation() != null) {
                context.setProperty("org.apache.servicemix.Operation", this.endpoint.getDefaultOperation());
            } else {
                QName bodyName = context.getInMessage().getBodyName();
                context.setProperty("org.apache.servicemix.Operation", bodyName);
            }
        }
        URI mep = null;
        if (operation != null) {
            mep = this.getMep(operation);
        }
        if (mep == null) {
            mep = this.endpoint.getDefaultMep();
        }
        MessageExchange exchange = this.createExchange(mep);
        exchange.setService((QName)context.getProperty("org.apache.servicemix.Service"));
        exchange.setInterfaceName((QName)context.getProperty("org.apache.servicemix.Interface"));
        exchange.setOperation((QName)context.getProperty("org.apache.servicemix.Operation"));
        if (context.getProperty("org.apache.servicemix.Endpoint") != null && (se = (componentContext = this.endpoint.getServiceUnit().getComponent().getComponentContext()).getEndpoint(serviceName = (QName)context.getProperty("org.apache.servicemix.Service"), endpointName = (String)context.getProperty("org.apache.servicemix.Endpoint"))) != null) {
            exchange.setEndpoint(se);
        }
        NormalizedMessage inMessage = exchange.createMessage();
        this.jbiMarshaler.toNMS(inMessage, context.getInMessage());
        exchange.setMessage(inMessage, "in");
        return exchange;
    }

    public SoapMessage onReply(Context context, NormalizedMessage outMsg) throws Exception {
        SoapMessage out = new SoapMessage();
        if (context.getInMessage() != null) {
            out.setEnvelopeName(context.getInMessage().getEnvelopeName());
        }
        this.jbiMarshaler.fromNMS(out, outMsg);
        context.setOutMessage(out);
        if (this.policies != null) {
            for (Handler policy : this.policies) {
                policy.onReply(context);
            }
        }
        return out;
    }

    public SoapMessage onFault(Context context, SoapFault fault) throws Exception {
        SoapMessage soapFault = new SoapMessage();
        soapFault.setFault(fault);
        if (context == null) {
            context = new Context();
        }
        if (context.getInMessage() != null) {
            soapFault.setEnvelopeName(context.getInMessage().getEnvelopeName());
        }
        context.setFaultMessage(soapFault);
        if (this.policies != null) {
            for (Handler policy : this.policies) {
                policy.onFault(context);
            }
        }
        return soapFault;
    }

    public void onSend(Context context) throws Exception {
        if (this.policies != null) {
            for (Handler policy : this.policies) {
                if (policy.requireDOM()) {
                    SoapWriter writer = this.soapMarshaler.createWriter(context.getInMessage());
                    W3CDOMStreamWriter domWriter = new W3CDOMStreamWriter();
                    writer.writeSoapEnvelope((XMLStreamWriter)domWriter);
                    context.getInMessage().setDocument(domWriter.getDocument());
                }
                policy.onSend(context);
            }
        }
    }

    public void onAnswer(Context context) throws Exception {
        if (this.policies != null) {
            for (Handler policy : this.policies) {
                policy.onAnswer(context);
            }
        }
    }

    public Context createContext(SoapMessage message) {
        Context context = this.createContext();
        context.setInMessage(message);
        return context;
    }

    public Context createContext() {
        Context context = new Context();
        context.setProperty("org.apache.servicemix.AuthenticationService", this.endpoint.getAuthenticationService());
        context.setProperty("org.apache.servicemix.KeystoreManager", this.endpoint.getKeystoreManager());
        return context;
    }

    protected MessageExchange createExchange(URI mep) throws MessagingException {
        ComponentContext context = this.endpoint.getServiceUnit().getComponent().getComponentContext();
        DeliveryChannel channel = context.getDeliveryChannel();
        MessageExchangeFactory factory = channel.createExchangeFactory();
        MessageExchange exchange = factory.createExchange(mep);
        return exchange;
    }

    private URI getMep(Operation oper) {
        URI mep = null;
        if (oper != null) {
            boolean faults;
            boolean output = oper.getOutput() != null && oper.getOutput().getMessage() != null && oper.getOutput().getMessage().getParts().size() > 0;
            boolean bl = faults = oper.getFaults().size() > 0;
            mep = output ? IN_OUT : (faults ? ROBUST_IN_ONLY : IN_ONLY);
        }
        return mep;
    }

    protected Operation findOperation(Context context) throws Exception {
        ServiceEndpoint[] ses;
        QName interfaceName = (QName)context.getProperty("org.apache.servicemix.Interface");
        QName serviceName = (QName)context.getProperty("org.apache.servicemix.Service");
        String endpointName = (String)context.getProperty("org.apache.servicemix.Endpoint");
        ComponentContext componentContext = this.endpoint.getServiceUnit().getComponent().getComponentContext();
        QName bodyName = context.getInMessage().getBodyName();
        ServiceEndpoint se = null;
        if (serviceName != null && endpointName != null) {
            se = componentContext.getEndpoint(serviceName, endpointName);
        }
        if (se == null && interfaceName != null && (ses = componentContext.getEndpoints(interfaceName)) != null && ses.length > 0) {
            se = ses[0];
        }
        Definition definition = null;
        if (se != null) {
            definition = this.getDefinition(se);
        }
        if (definition == null) {
            definition = this.endpoint.getDefinition();
        }
        if (definition != null) {
            if (interfaceName != null) {
                PortType portType = definition.getPortType(interfaceName);
                if (portType != null) {
                    return this.findOperationFor(portType, bodyName);
                }
            } else if (definition.getService(serviceName) != null) {
                PortType portType;
                Port port;
                Binding binding;
                Service service = definition.getService(serviceName);
                if (endpointName != null) {
                    PortType portType2;
                    Binding binding2;
                    Port port2 = service.getPort(endpointName);
                    if (port2 != null && (binding2 = port2.getBinding()) != null && (portType2 = binding2.getPortType()) != null) {
                        return this.findOperationFor(portType2, bodyName);
                    }
                } else if (service.getPorts().size() == 1 && (binding = (port = (Port)service.getPorts().values().iterator().next()).getBinding()) != null && (portType = binding.getPortType()) != null) {
                    return this.findOperationFor(portType, bodyName);
                }
            } else if (definition.getPortTypes().size() == 1) {
                PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
                return this.findOperationFor(portType, bodyName);
            }
        }
        return null;
    }

    protected Operation findOperationFor(PortType portType, QName bodyName) {
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            Operation operation = (Operation)list.get(i);
            if (operation.getInput() == null || operation.getInput().getMessage() == null) continue;
            Map parts = operation.getInput().getMessage().getParts();
            for (Part part : parts.values()) {
                QName elementName = part.getElementName();
                if (elementName == null || !elementName.equals(bodyName)) continue;
                this.operationNames.put(operation, new QName(portType.getQName().getNamespaceURI(), operation.getName()));
                return operation;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Definition getDefinition(ServiceEndpoint se) throws WSDLException, JBIException {
        Definition definition;
        ComponentContext componentContext = this.endpoint.getServiceUnit().getComponent().getComponentContext();
        String key = se.getServiceName() + se.getEndpointName();
        Map map = this.definitions;
        synchronized (map) {
            block7: {
                definition = (Definition)this.definitions.get(key);
                if (definition == null) {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    Document description = componentContext.getEndpointDescriptor(se);
                    if (description != null) {
                        WSDLReader reader = factory.newWSDLReader();
                        reader.setFeature("javax.wsdl.verbose", false);
                        try {
                            definition = reader.readWSDL(null, description);
                            this.definitions.put(key, definition);
                        }
                        catch (WSDLException e) {
                            logger.info((Object)("Could not read wsdl from endpoint descriptor: " + e.getMessage()));
                            if (!logger.isDebugEnabled()) break block7;
                            logger.debug((Object)"Could not read wsdl from endpoint descriptor", (Throwable)e);
                        }
                    }
                }
            }
        }
        return definition;
    }
}

