/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.common.security.AuthenticationService;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.common.wsdl1.JbiExtension;
import org.apache.servicemix.soap.handlers.addressing.AddressingHandler;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public abstract class SoapEndpoint
extends Endpoint {
    protected ServiceEndpoint activated;
    protected ExchangeProcessor processor;
    protected MessageExchange.Role role;
    protected URI defaultMep = JbiConstants.IN_OUT;
    protected boolean soap;
    protected String soapVersion;
    protected Resource wsdlResource;
    protected QName defaultOperation;
    protected QName targetInterfaceName;
    protected QName targetService;
    protected String targetEndpoint;
    protected List policies;
    protected Map wsdls = new HashMap();

    public SoapEndpoint() {
        this.policies = Collections.singletonList(new AddressingHandler());
    }

    public AuthenticationService getAuthenticationService() {
        return null;
    }

    public KeystoreManager getKeystoreManager() {
        return null;
    }

    public List getPolicies() {
        return this.policies;
    }

    public void setPolicies(List policies) {
        this.policies = policies;
    }

    public URI getDefaultMep() {
        return this.defaultMep;
    }

    public void setDefaultMep(URI defaultMep) {
        this.defaultMep = defaultMep;
    }

    public QName getDefaultOperation() {
        return this.defaultOperation;
    }

    public void setDefaultOperation(QName defaultOperation) {
        this.defaultOperation = defaultOperation;
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public void setRole(MessageExchange.Role role) {
        this.role = role;
    }

    public boolean isSoap() {
        return this.soap;
    }

    public void setSoap(boolean soap) {
        this.soap = soap;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    public QName getTargetInterfaceName() {
        return this.targetInterfaceName;
    }

    public void setTargetInterfaceName(QName targetInterfaceName) {
        this.targetInterfaceName = targetInterfaceName;
    }

    public QName getTargetService() {
        return this.targetService;
    }

    public void setTargetService(QName targetServiceName) {
        this.targetService = targetServiceName;
    }

    public Resource getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    public void setRoleAsString(String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role must be specified");
        }
        if ("consumer".equals(role)) {
            this.setRole(MessageExchange.Role.CONSUMER);
        } else if ("provider".equals(role)) {
            this.setRole(MessageExchange.Role.PROVIDER);
        } else {
            throw new IllegalArgumentException("Unrecognized role: " + role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadWsdl() {
        if (this.description == null && this.wsdlResource != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.serviceUnit.getConfigurationClassLoader());
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                Definition def = reader.readWSDL(this.wsdlResource.getURL().toString());
                this.overrideDefinition(def);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not load description from resource", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        if (this.description == null && this.definition == null && this.getRole() == MessageExchange.Role.CONSUMER) {
            this.retrieveProxiedEndpointDefinition();
        }
        if (this.description == null && this.definition != null) {
            try {
                this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not create document from wsdl description", (Throwable)e);
            }
        }
        if (this.definition == null && this.description != null) {
            try {
                this.definition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, this.description);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not create wsdl definition from dom document", (Throwable)e);
            }
        }
        if (this.definition != null) {
            try {
                this.mapDefinition(this.definition);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Could not map wsdl definition to documents", (Throwable)e);
            }
        }
    }

    protected void retrieveProxiedEndpointDefinition() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Retrieving proxied endpoint definition");
        }
        try {
            Document doc;
            ServiceEndpoint[] eps;
            ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
            ServiceEndpoint ep = null;
            if (this.targetService != null && this.targetEndpoint != null && (ep = ctx.getEndpoint(this.targetService, this.targetEndpoint)) == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Could not retrieve endpoint targetService/targetEndpoint");
            }
            if (ep == null && this.targetService != null) {
                eps = ctx.getEndpointsForService(this.targetService);
                if (eps != null && eps.length > 0) {
                    ep = eps[0];
                }
                if (ep == null && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Could not retrieve endpoint for targetService");
                }
            }
            if (ep == null && this.targetInterfaceName != null) {
                eps = ctx.getEndpoints(this.targetInterfaceName);
                if (eps != null && eps.length > 0) {
                    ep = eps[0];
                }
                if (ep == null && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Could not retrieve endpoint for targetInterfaceName");
                }
            }
            if (ep == null && this.service != null && this.endpoint != null && (ep = ctx.getEndpoint(this.service, this.endpoint)) == null && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Could not retrieve endpoint for service/endpoint");
            }
            if (ep != null && (doc = ctx.getEndpointDescriptor(ep)) != null) {
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                Definition def = reader.readWSDL(null, doc);
                if (def != null) {
                    this.overrideDefinition(def);
                }
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"Unable to retrieve target endpoint descriptor", (Throwable)e);
        }
    }

    public ExchangeProcessor getProcessor() {
        return this.processor;
    }

    public void activate() throws Exception {
        ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
        this.loadWsdl();
        if (this.getRole() == MessageExchange.Role.PROVIDER) {
            this.activated = ctx.activateEndpoint(this.service, this.endpoint);
            this.processor = this.createProviderProcessor();
        } else {
            this.activated = this.createExternalEndpoint();
            ctx.registerExternalEndpoint(this.activated);
            this.processor = this.createConsumerProcessor();
        }
        this.processor.start();
    }

    public void activateDynamic() throws Exception {
        this.processor = this.getRole() == MessageExchange.Role.PROVIDER ? this.createProviderProcessor() : this.createConsumerProcessor();
        this.processor.start();
    }

    public void deactivate() throws Exception {
        if (this.activated != null) {
            ComponentContext ctx = this.serviceUnit.getComponent().getComponentContext();
            if (this.getRole() == MessageExchange.Role.PROVIDER) {
                ServiceEndpoint ep = this.activated;
                this.activated = null;
                ctx.deactivateEndpoint(ep);
            } else {
                ServiceEndpoint ep = this.activated;
                this.activated = null;
                ctx.deregisterExternalEndpoint(ep);
            }
        }
        this.processor.stop();
    }

    protected abstract void overrideDefinition(Definition var1) throws Exception;

    protected abstract ExchangeProcessor createProviderProcessor();

    protected abstract ExchangeProcessor createConsumerProcessor();

    protected abstract ServiceEndpoint createExternalEndpoint();

    protected WSDLReader createWsdlReader() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        this.registerExtensions(registry);
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(registry);
        return reader;
    }

    protected WSDLWriter createWsdlWriter() throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        this.registerExtensions(registry);
        WSDLWriter writer = factory.newWSDLWriter();
        return writer;
    }

    protected void registerExtensions(ExtensionRegistry registry) {
        JbiExtension.register((ExtensionRegistry)registry);
    }

    protected void mapDefinition(Definition def) throws WSDLException {
        this.wsdls.put("main.wsdl", this.createWsdlWriter().getDocument(def));
        this.mapImports(def);
    }

    protected void mapImports(Definition def) throws WSDLException {
        Map imports = def.getImports();
        for (List imps : imports.values()) {
            for (Import imp : imps) {
                Definition impDef = imp.getDefinition();
                String impLoc = imp.getLocationURI();
                if (impDef == null || impLoc == null || URI.create(impLoc).isAbsolute()) continue;
                this.wsdls.put(impLoc, this.createWsdlWriter().getDocument(impDef));
                this.mapImports(impDef);
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement ee : types.getExtensibilityElements()) {
                if (!(ee instanceof Schema)) continue;
                Schema schema = (Schema)ee;
                this.mapSchemaImport(schema);
            }
        }
    }

    private void mapSchemaImport(Schema schema) {
        Map schemaImports = schema.getImports();
        for (List imps : schemaImports.values()) {
            for (SchemaImport schemaImport : imps) {
                Schema schemaImp = schemaImport.getReferencedSchema();
                String schemaLoc = schemaImport.getSchemaLocationURI();
                if (schemaLoc == null || schemaImp == null || schemaImp.getElement() == null || URI.create(schemaLoc).isAbsolute()) continue;
                this.wsdls.put(schemaLoc, schemaImp.getElement());
                this.mapSchemaImport(schemaImp);
            }
        }
    }

    public Map getWsdls() {
        return this.wsdls;
    }
}

