/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.marshalers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URI;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.jbi.jaxp.ExtendedXMLStreamReader;
import org.apache.servicemix.jbi.jaxp.FragmentStreamReader;
import org.apache.servicemix.jbi.jaxp.StaxSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.marshalers.SoapMarshaler;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapReader {
    private SoapMarshaler marshaler;
    protected static final Source EMPTY_CONTENT = new StringSource("<payload/>");

    public SoapReader(SoapMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public SoapMessage read(InputStream is, String contentType) throws Exception {
        if (contentType != null && contentType.toLowerCase().startsWith("multipart/")) {
            Session session = Session.getDefaultInstance((Properties)new Properties());
            is = new SequenceInputStream(new ByteArrayInputStream(new byte[]{13, 10}), is);
            MimeMessage mime = new MimeMessage(session, is);
            mime.setHeader("Content-Type", contentType);
            return this.read(mime);
        }
        return this.read(is);
    }

    public SoapMessage read(InputStream is) throws Exception {
        if (this.marshaler.isSoap()) {
            if (this.marshaler.isUseDom()) {
                return this.readSoapUsingDom(is);
            }
            return this.readSoapUsingStax(is);
        }
        SoapMessage message = new SoapMessage();
        message.setSource(new StreamSource(is));
        return message;
    }

    private SoapMessage readSoapUsingDom(InputStream is) throws Exception {
        SoapMessage message = new SoapMessage();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(is);
        message.setDocument(doc);
        Element env = doc.getDocumentElement();
        QName envName = DOMUtil.getQName((Element)env);
        if (!envName.getLocalPart().equals("Envelope")) {
            throw new SoapFault(SoapFault.SENDER, "Unrecognized element: " + envName + ". Expecting 'Envelope'.");
        }
        message.setEnvelopeName(envName);
        String soapUri = envName.getNamespaceURI();
        if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(soapUri) && !"http://www.w3.org/2003/05/soap-envelope".equals(soapUri)) {
            throw new SoapFault(SoapFault.SENDER, "Unrecognized namespace: " + soapUri + " for element 'Envelope'.");
        }
        Element child = DOMUtil.getFirstChildElement((Node)env);
        if (DOMUtil.getQName((Element)child).equals(new QName(soapUri, "Header"))) {
            this.parseHeaders(message, child);
            child = DOMUtil.getNextSiblingElement((Element)child);
        }
        if (!DOMUtil.getQName((Element)child).equals(new QName(soapUri, "Body"))) {
            throw new SoapFault(SoapFault.SENDER, "Unrecognized element: " + DOMUtil.getQName((Element)child) + ". Expecting 'Body'.");
        }
        if ((child = DOMUtil.getFirstChildElement((Node)child)) != null) {
            QName childName = DOMUtil.getQName((Element)child);
            message.setBodyName(childName);
            if (childName.equals(new QName(soapUri, "Fault"))) {
                message.setFault(this.readFaultUsingDom(child));
            } else {
                message.setSource(new DOMSource(child));
            }
        }
        if ((child = DOMUtil.getNextSiblingElement((Element)child)) != null) {
            throw new SoapFault(SoapFault.RECEIVER, "Body element has more than one child element.");
        }
        return message;
    }

    private void parseHeaders(SoapMessage message, Element headers) {
        Element child = DOMUtil.getFirstChildElement((Node)headers);
        while (child != null) {
            DocumentFragment df = child.getOwnerDocument().createDocumentFragment();
            df.appendChild(child.cloneNode(true));
            message.addHeader(DOMUtil.getQName((Element)child), df);
            child = DOMUtil.getNextSiblingElement((Element)child);
        }
    }

    private SoapMessage readSoapUsingStax(InputStream is) throws Exception {
        SoapMessage message = new SoapMessage();
        XMLStreamReader reader = this.marshaler.getInputFactory().createXMLStreamReader(is);
        reader = new ExtendedXMLStreamReader(reader);
        reader.nextTag();
        if (!reader.getLocalName().equals("Envelope")) {
            throw new SoapFault(SoapFault.SENDER, "Unrecognized element: " + reader.getName() + " at [" + reader.getLocation().getLineNumber() + "," + reader.getLocation().getColumnNumber() + "]. Expecting 'Envelope'.");
        }
        message.setEnvelopeName(reader.getName());
        String soapUri = reader.getNamespaceURI();
        if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(soapUri) && !"http://www.w3.org/2003/05/soap-envelope".equals(soapUri)) {
            throw new SoapFault(SoapFault.SENDER, "Unrecognized namespace: " + soapUri + " for element 'Envelope' at [" + reader.getLocation().getLineNumber() + "," + reader.getLocation().getColumnNumber() + "]. Expecting 'Envelope'.");
        }
        reader.nextTag();
        if (reader.getName().equals(new QName(soapUri, "Header"))) {
            this.parseHeaders(message, reader);
            reader.nextTag();
        }
        if (!reader.getName().equals(new QName(soapUri, "Body"))) {
            throw new SoapFault(SoapFault.SENDER, "Unrecognized element: " + reader.getName() + " at [" + reader.getLocation().getLineNumber() + "," + reader.getLocation().getColumnNumber() + "]. Expecting 'Body'.");
        }
        if (reader.nextTag() != 2) {
            QName childName = reader.getName();
            message.setBodyName(childName);
            if (childName.equals(new QName(soapUri, "Fault"))) {
                message.setFault(this.readFaultUsingStax(reader));
            } else {
                message.setSource((Source)new StaxSource((XMLStreamReader)new FragmentStreamReader(reader)));
            }
        }
        return message;
    }

    private SoapFault readFaultUsingDom(Element element) throws SoapFault {
        Element child;
        QName code = null;
        QName subcode = null;
        String reason = null;
        URI node = null;
        URI role = null;
        DOMSource details = null;
        if (element.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            child = DOMUtil.getFirstChildElement((Node)element);
            this.checkElementName(child, SoapMarshaler.SOAP_11_FAULTCODE);
            code = DOMUtil.createQName((Element)child, (String)DOMUtil.getElementText((Element)child));
            child = DOMUtil.getNextSiblingElement((Element)child);
            this.checkElementName(child, SoapMarshaler.SOAP_11_FAULTSTRING);
            reason = DOMUtil.getElementText((Element)child);
            child = DOMUtil.getNextSiblingElement((Element)child);
            QName childname = DOMUtil.getQName((Element)child);
            if (SoapMarshaler.SOAP_11_FAULTACTOR.equals(childname)) {
                node = URI.create(DOMUtil.getElementText((Element)child));
                child = DOMUtil.getNextSiblingElement((Element)child);
                childname = DOMUtil.getQName((Element)child);
            }
            if (SoapMarshaler.SOAP_11_FAULTDETAIL.equals(childname)) {
                Element subchild = DOMUtil.getFirstChildElement((Node)child);
                if (subchild != null) {
                    details = new DOMSource(subchild);
                    if ((subchild = DOMUtil.getNextSiblingElement((Element)subchild)) != null) {
                        throw new SoapFault(SoapFault.RECEIVER, "Multiple elements are not supported in Detail");
                    }
                }
                child = DOMUtil.getNextSiblingElement((Element)child);
                childname = DOMUtil.getQName((Element)child);
            }
            if (childname != null) {
                throw new SoapFault(SoapFault.SENDER, "Unexpected element: " + childname);
            }
        } else {
            child = DOMUtil.getFirstChildElement((Node)element);
            this.checkElementName(child, SoapMarshaler.SOAP_12_FAULTCODE);
            Element subchild = DOMUtil.getFirstChildElement((Node)child);
            this.checkElementName(subchild, SoapMarshaler.SOAP_12_FAULTVALUE);
            code = DOMUtil.createQName((Element)subchild, (String)DOMUtil.getElementText((Element)subchild));
            if (!(SoapMarshaler.SOAP_12_CODE_DATAENCODINGUNKNOWN.equals(code) || SoapMarshaler.SOAP_12_CODE_MUSTUNDERSTAND.equals(code) || SoapMarshaler.SOAP_12_CODE_RECEIVER.equals(code) || SoapMarshaler.SOAP_12_CODE_SENDER.equals(code) || SoapMarshaler.SOAP_12_CODE_VERSIONMISMATCH.equals(code))) {
                throw new SoapFault(SoapFault.SENDER, "Unexpected fault code: " + code);
            }
            if ((subchild = DOMUtil.getNextSiblingElement((Element)subchild)) != null) {
                this.checkElementName(subchild, SoapMarshaler.SOAP_12_FAULTSUBCODE);
                Element subsubchild = DOMUtil.getFirstChildElement((Node)subchild);
                this.checkElementName(subsubchild, SoapMarshaler.SOAP_12_FAULTVALUE);
                subcode = DOMUtil.createQName((Element)subsubchild, (String)DOMUtil.getElementText((Element)subsubchild));
                subsubchild = DOMUtil.getNextSiblingElement((Element)subsubchild);
                if (subsubchild != null) {
                    this.checkElementName(subsubchild, SoapMarshaler.SOAP_12_FAULTSUBCODE);
                    throw new SoapFault(SoapFault.RECEIVER, "Unsupported nested subcodes");
                }
            }
            child = DOMUtil.getNextSiblingElement((Element)child);
            this.checkElementName(child, SoapMarshaler.SOAP_12_FAULTREASON);
            subchild = DOMUtil.getFirstChildElement((Node)child);
            this.checkElementName(subchild, SoapMarshaler.SOAP_12_FAULTTEXT);
            reason = DOMUtil.getElementText((Element)subchild);
            subchild = DOMUtil.getNextSiblingElement((Element)subchild);
            if (subchild != null) {
                throw new SoapFault(SoapFault.RECEIVER, "Unsupported multiple reasons");
            }
            QName childname = DOMUtil.getQName((Element)(child = DOMUtil.getNextSiblingElement((Element)child)));
            if (SoapMarshaler.SOAP_12_FAULTNODE.equals(childname)) {
                node = URI.create(DOMUtil.getElementText((Element)child));
                child = DOMUtil.getNextSiblingElement((Element)child);
                childname = DOMUtil.getQName((Element)child);
            }
            if (SoapMarshaler.SOAP_12_FAULTROLE.equals(childname)) {
                role = URI.create(DOMUtil.getElementText((Element)child));
                child = DOMUtil.getNextSiblingElement((Element)child);
                childname = DOMUtil.getQName((Element)child);
            }
            if (SoapMarshaler.SOAP_12_FAULTDETAIL.equals(childname)) {
                subchild = DOMUtil.getFirstChildElement((Node)child);
                if (subchild != null) {
                    details = new DOMSource(subchild);
                    if ((subchild = DOMUtil.getNextSiblingElement((Element)subchild)) != null) {
                        throw new SoapFault(SoapFault.RECEIVER, "Multiple elements are not supported in Detail");
                    }
                }
                child = DOMUtil.getNextSiblingElement((Element)child);
                childname = DOMUtil.getQName((Element)child);
            }
            if (childname != null) {
                throw new SoapFault(SoapFault.SENDER, "Unexpected element: " + childname);
            }
        }
        SoapFault fault = new SoapFault(code, subcode, reason, node, role, details);
        return fault;
    }

    private SoapFault readFaultUsingStax(XMLStreamReader reader) throws SoapFault {
        try {
            FragmentStreamReader rh = new FragmentStreamReader(reader);
            Document doc = (Document)this.marshaler.getSourceTransformer().toDOMNode((Source)new StaxSource((XMLStreamReader)rh));
            return this.readFaultUsingDom(doc.getDocumentElement());
        }
        catch (SoapFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new SoapFault(e);
        }
    }

    private void checkElementName(Element element, QName expected) throws SoapFault {
        QName name = DOMUtil.getQName((Element)element);
        if (!expected.equals(name)) {
            throw new SoapFault(SoapFault.SENDER, "Expected element: " + expected + " but found " + name);
        }
    }

    private void parseHeaders(SoapMessage message, XMLStreamReader reader) throws Exception {
        while (reader.nextTag() != 2) {
            QName hn = reader.getName();
            FragmentStreamReader rh = new FragmentStreamReader(reader);
            Document doc = (Document)this.marshaler.getSourceTransformer().toDOMNode((Source)new StaxSource((XMLStreamReader)rh));
            DocumentFragment df = doc.createDocumentFragment();
            df.appendChild(doc.getDocumentElement());
            message.addHeader(hn, df);
        }
    }

    public SoapMessage read(MimeMessage mime) throws Exception {
        Object content = mime.getContent();
        if (content instanceof MimeMultipart) {
            MimeMultipart multipart = (MimeMultipart)content;
            ContentType type = new ContentType(mime.getContentType());
            String contentId = type.getParameter("start");
            MimeBodyPart contentPart = null;
            if (contentId != null) {
                contentPart = (MimeBodyPart)multipart.getBodyPart(contentId);
            } else {
                for (int i = 0; i < multipart.getCount(); ++i) {
                    MimeBodyPart contentPart2 = (MimeBodyPart)multipart.getBodyPart(i);
                    String contentType = contentPart2.getContentType();
                    if (contentType.indexOf("xml") < 0) continue;
                    contentPart = contentPart2;
                    break;
                }
            }
            SoapMessage message = null;
            if (contentPart != null) {
                message = this.read(contentPart.getInputStream());
            } else {
                message = new SoapMessage();
                message.setSource(EMPTY_CONTENT);
            }
            for (int i = 0; i < multipart.getCount(); ++i) {
                MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
                if (part == contentPart) continue;
                String id = part.getContentID();
                if (id == null) {
                    id = "Part" + i;
                } else if (id.startsWith("<")) {
                    id = id.substring(1, id.length() - 1);
                }
                message.addAttachment(id, part.getDataHandler());
            }
            return message;
        }
        throw new UnsupportedOperationException("Expected a javax.mail.internet.MimeMultipart object");
    }
}

