/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.security;

import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.servicemix.jbi.security.keystore.KeystoreInstance;
import org.apache.servicemix.jbi.security.keystore.KeystoreManager;
import org.apache.servicemix.soap.handlers.security.BaseCrypto;

public class KeystoreInstanceCrypto
extends BaseCrypto {
    private KeystoreInstance keystore;

    public KeystoreInstanceCrypto() {
    }

    public KeystoreInstanceCrypto(KeystoreInstance keystore) {
        this.keystore = keystore;
    }

    public KeystoreInstanceCrypto(KeystoreManager keystoreManager, String keystore) {
        this.keystore = keystoreManager.getKeystore(keystore);
    }

    public KeystoreInstance getKeystore() {
        return this.keystore;
    }

    public void setKeystore(KeystoreInstance keystore) {
        this.keystore = keystore;
    }

    protected String[] getAliases() throws KeyStoreException {
        String[] pks = this.keystore.listPrivateKeys();
        String[] tcs = this.keystore.listTrustCertificates();
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.addAll(Arrays.asList(pks));
        aliases.addAll(Arrays.asList(tcs));
        return aliases.toArray(new String[aliases.size()]);
    }

    protected Certificate getCertificate(String alias) throws KeyStoreException {
        return this.keystore.getCertificate(alias);
    }

    protected String getCertificateAlias(Certificate cert) throws KeyStoreException {
        return this.keystore.getCertificateAlias(cert);
    }

    protected Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        return this.keystore.getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias, String password) throws Exception {
        return this.keystore.getPrivateKey(alias);
    }

    protected String[] getTrustCertificates() throws KeyStoreException {
        return this.keystore.listTrustCertificates();
    }
}

