/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.handlers.addressing;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapFault;
import org.apache.servicemix.soap.handlers.AbstractHandler;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class AddressingHandler
extends AbstractHandler {
    protected final SourceTransformer sourceTransformer = new SourceTransformer();
    protected final IdGenerator idGenerator = new IdGenerator();

    public void onReceive(Context context) throws Exception {
        SoapMessage message = context.getInMessage();
        String action = null;
        String to = null;
        String nsUri = null;
        Map headers = message.getHeaders();
        if (headers != null) {
            for (QName qname : headers.keySet()) {
                String[] parts;
                Object value = headers.get(qname);
                if (!this.isWSANamespace(qname.getNamespaceURI())) continue;
                if (nsUri == null) {
                    nsUri = qname.getNamespaceURI();
                } else if (!nsUri.equals(qname.getNamespaceURI())) {
                    throw new SoapFault(SoapFault.SENDER, "Inconsistent use of wsa namespaces");
                }
                if ("Action".equals(qname.getLocalPart())) {
                    action = this.getHeaderText(value);
                    parts = URIResolver.split3((String)action);
                    context.setProperty("org.apache.servicemix.Interface", new QName(parts[0], parts[1]));
                    context.setProperty("org.apache.servicemix.Operation", new QName(parts[0], parts[2]));
                    continue;
                }
                if (!"To".equals(qname.getLocalPart())) continue;
                to = this.getHeaderText(value);
                parts = URIResolver.split3((String)to);
                context.setProperty("org.apache.servicemix.Service", new QName(parts[0], parts[1]));
                context.setProperty("org.apache.servicemix.Endpoint", parts[2]);
            }
        }
    }

    public void onReply(Context context) throws Exception {
        SoapMessage in = context.getInMessage();
        SoapMessage out = context.getOutMessage();
        Map headers = in.getHeaders();
        if (headers != null) {
            for (QName qname : headers.keySet()) {
                Object value = headers.get(qname);
                if (!this.isWSANamespace(qname.getNamespaceURI()) || !"MessageID".equals(qname.getLocalPart())) continue;
                QName name = new QName(qname.getNamespaceURI(), "MessageID", qname.getPrefix() != null ? qname.getPrefix() : "wsa");
                DocumentFragment df = this.createHeader(name, this.idGenerator.generateSanitizedId());
                out.addHeader(name, df);
                name = new QName(qname.getNamespaceURI(), "RelatesTo", qname.getPrefix() != null ? qname.getPrefix() : "wsa");
                df = this.createHeader(name, this.getHeaderText(value));
                out.addHeader(name, df);
            }
        }
    }

    protected boolean isWSANamespace(String ns) {
        return "http://schemas.xmlsoap.org/ws/2003/03/addressing".equals(ns) || "http://schemas.xmlsoap.org/ws/2004/03/addressing".equals(ns) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns) || "http://www.w3.org/2005/08/addressing".equals(ns);
    }

    protected String getHeaderText(Object header) {
        Element el = (Element)((DocumentFragment)header).getFirstChild();
        return DOMUtil.getElementText((Element)el);
    }

    protected DocumentFragment createHeader(QName name, String value) throws Exception {
        Document doc = new SourceTransformer().createDocument();
        DocumentFragment df = doc.createDocumentFragment();
        Element el = doc.createElementNS(name.getNamespaceURI(), name.getPrefix() + ":" + name.getLocalPart());
        el.appendChild(doc.createTextNode(value));
        df.appendChild(el);
        return df;
    }
}

