/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.xml;

import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.core.AbstractInterceptor;
import org.apache.servicemix.soap.util.stax.StaxUtil;

public class StaxOutInterceptor
extends AbstractInterceptor {
    public void handleMessage(Message message) {
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            throw new NullPointerException("OutputStream content not found");
        }
        try {
            XMLStreamWriter writer = StaxUtil.createWriter(os);
            message.setContent(XMLStreamWriter.class, writer);
            InterceptorChain chain = message.get(InterceptorChain.class);
            chain.doIntercept(message);
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new Fault(e);
        }
    }
}

