/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.interceptors.mime;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.servicemix.soap.api.Fault;
import org.apache.servicemix.soap.api.InterceptorChain;
import org.apache.servicemix.soap.api.Message;
import org.apache.servicemix.soap.core.AbstractInterceptor;

public class AttachmentsOutInterceptor
extends AbstractInterceptor {
    public static final String PIPE_ATTACHMENT_STREAM = "PipeAttachmentStream";
    public static final String SOAP_PART_ID = "soap-request";

    public void handleMessage(Message message) {
        if (message.getAttachments().size() == 0) {
            return;
        }
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            throw new NullPointerException("OutputStream content not found");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.setContent(OutputStream.class, baos);
            message.put("Content-Type", "multipart/related; type=\"text/xml\"; start=\"<soap-request>\"");
            InterceptorChain chain = message.get(InterceptorChain.class);
            chain.doIntercept(message);
            this.writeMultipartMessage(message, os, baos.toByteArray());
        }
        catch (MessagingException e) {
            throw new Fault(e);
        }
        catch (IOException e) {
            throw new Fault(e);
        }
    }

    protected boolean getBoolean(Message message, String name, boolean def) {
        Object b = message.get(name);
        if (b instanceof Boolean) {
            return (Boolean)b;
        }
        if (b != null) {
            return Boolean.parseBoolean(b.toString());
        }
        return def;
    }

    private void writeMultipartMessage(Message message, OutputStream out, byte[] data) throws MessagingException, IOException {
        MimeMultipart parts = new MimeMultipart("related; type=\"text/xml\"; start=\"<soap-request>\"");
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage mime = new MimeMessage(session);
        MimeBodyPart soapPart = new MimeBodyPart();
        soapPart.setContentID("<soap-request>");
        soapPart.addHeader("Content-Transfer-Encoding", "8bit");
        soapPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, "text/xml")));
        parts.addBodyPart((BodyPart)soapPart);
        for (Map.Entry<String, DataHandler> entry : message.getAttachments().entrySet()) {
            String id = entry.getKey();
            DataHandler dh = entry.getValue();
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(dh);
            part.setContentID("<" + id + ">");
            part.addHeader("Content-Transfer-Encoding", "binary");
            parts.addBodyPart((BodyPart)part);
        }
        mime.setContent((Multipart)parts);
        mime.setHeader("Content-Type", parts.getContentType());
        mime.saveChanges();
        Enumeration headersEnum = mime.getAllHeaders();
        ArrayList<String> headersList = new ArrayList<String>();
        while (headersEnum.hasMoreElements()) {
            headersList.add(((Header)headersEnum.nextElement()).getName().toLowerCase());
        }
        String[] headers = headersList.toArray(new String[0]);
        FilterOutputStream os = new FilterOutputStream(out){
            private int nb;
            {
                this.nb = 0;
            }

            public void write(int b) throws IOException {
                if (++this.nb > 2) {
                    super.write(b);
                }
            }
        };
        mime.writeTo((OutputStream)os, headers);
    }
}

