/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class TarBZip2Driver
extends TarDriver {
    private static final long serialVersionUID = 4966248471134003932L;
    private static final int BUFSIZE = 4096;
    public static final int BLOCKSIZE = 9;
    private final int blockSize;

    public TarBZip2Driver() {
        this("US-ASCII", 9);
    }

    public TarBZip2Driver(String encoding) {
        this(encoding, 9);
    }

    public TarBZip2Driver(int blockSize) {
        this("US-ASCII", blockSize);
    }

    public TarBZip2Driver(String encoding, int blockSize) {
        super(encoding, null, null);
        this.blockSize = blockSize;
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile rof) throws IOException {
        InputStream in = super.createInputStream(archive, rof);
        if (in.read() != 66 || in.read() != 90) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        byte[] magic = new byte[2];
        InputStream vin = TarInputArchive.readAhead(in, magic);
        if (magic[0] != 104 || magic[1] < 49 || 57 < magic[1]) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        return new CBZip2InputStream((InputStream)new BufferedInputStream(vin, 4096));
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream out, TarInputArchive source) throws IOException {
        out.write(new byte[]{66, 90});
        return super.createTarOutputArchive(archive, (OutputStream)new CBZip2OutputStream((OutputStream)new BufferedOutputStream(out, 4096), this.blockSize), source);
    }
}

