/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class TarGZipDriver
extends TarDriver {
    private static final long serialVersionUID = 7736164529936091928L;
    private static final int BUFSIZE = 4096;

    public TarGZipDriver() {
        super("US-ASCII", null, null);
    }

    public TarGZipDriver(String encoding) {
        super(encoding, null, null);
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile rof) throws IOException {
        return new GZIPInputStream(super.createInputStream(archive, rof), 4096);
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream out, TarInputArchive source) throws IOException {
        return super.createTarOutputArchive(archive, new GZIPOutputStream(out, 4096), source);
    }
}

