/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.util.Paths;
import de.schlichtherle.util.zip.BasicZipFile;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.zip.ZipException;

public class Zip32InputArchive
extends BasicZipFile
implements InputArchive {
    private InputArchiveMetaData metaData;

    public Zip32InputArchive(ReadOnlyFile rof, String encoding, boolean preambled, boolean postambled) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        super(rof, encoding, preambled, postambled);
    }

    protected ZipEntry createZipEntry(String entryName) {
        return new Zip32Entry(Paths.normalize(entryName, '/'));
    }

    public int getNumArchiveEntries() {
        return super.size();
    }

    public Enumeration getArchiveEntries() {
        return super.entries();
    }

    public ArchiveEntry getArchiveEntry(String entryName) {
        return (Zip32Entry)super.getEntry(entryName);
    }

    public InputStream getInputStream(ArchiveEntry entry, ArchiveEntry dstEntry) throws IOException {
        return super.getInputStream(entry.getName(), false, !(dstEntry instanceof Zip32Entry));
    }

    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InputArchiveMetaData metaData) {
        this.metaData = metaData;
    }
}

