/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.AbstractReadOnlyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ChannelReadOnlyFile
extends AbstractReadOnlyFile {
    private final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);
    private final FileChannel channel;

    public ChannelReadOnlyFile(File file) throws FileNotFoundException {
        this.channel = new FileInputStream(file).getChannel();
    }

    public long length() throws IOException {
        return this.channel.size();
    }

    public long getFilePointer() throws IOException {
        return this.channel.position();
    }

    public void seek(long fp) throws IOException {
        try {
            this.channel.position(fp);
        }
        catch (IllegalArgumentException iae) {
            IOException ioe = new IOException(iae.toString());
            ioe.initCause(iae);
            throw ioe;
        }
    }

    public int read() throws IOException {
        this.singleByteBuffer.position(0);
        if (this.channel.read(this.singleByteBuffer) == 1) {
            return this.singleByteBuffer.array()[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.channel.read(ByteBuffer.wrap(buf, off, len));
    }

    public void close() throws IOException {
        this.channel.close();
    }
}

