/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.truezip;

import de.schlichtherle.io.FileOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.truezip.TrueZipComponent;
import org.apache.servicemix.truezip.TrueZipEndpointType;

public class TrueZipSenderEndpoint
extends ProviderEndpoint
implements TrueZipEndpointType {
    private de.schlichtherle.io.File directory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private String tempFilePrefix = "servicemix-";
    private String tempFileSuffix = ".xml";
    private boolean autoCreateDirectory = true;
    private IdGenerator idGenerator;

    public TrueZipSenderEndpoint() {
    }

    public TrueZipSenderEndpoint(TrueZipComponent component, ServiceEndpoint endpoint) {
        super((DefaultComponent)component, endpoint);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.directory == null) {
            throw new DeploymentException("You must specify the directory property");
        }
        if (this.isAutoCreateDirectory()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new DeploymentException("The directory property must be a directory but was: " + this.directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        OutputStream out = null;
        try {
            String name = this.marshaler.getOutputName(exchange, in);
            de.schlichtherle.io.File newFile = null;
            newFile = name == null ? new de.schlichtherle.io.File((File)this.directory, this.getNewTempName()) : new de.schlichtherle.io.File((File)this.directory, name);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Writing to file: " + newFile.getCanonicalPath()));
            }
            out = new BufferedOutputStream((OutputStream)new FileOutputStream((File)newFile));
            this.marshaler.writeMessage(exchange, in, out, name);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)("Caught exception while closing stream on error: " + e), (Throwable)e);
                }
            }
        }
    }

    protected String getNewTempName() {
        if (this.idGenerator == null) {
            this.idGenerator = new IdGenerator(this.tempFilePrefix);
        }
        return this.idGenerator.generateSanitizedId() + this.tempFileSuffix;
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        super.processInOut(exchange, in, out);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = new de.schlichtherle.io.File(directory);
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public void setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
    }

    public String getTempFileSuffix() {
        return this.tempFileSuffix;
    }

    public void setTempFileSuffix(String tempFileSuffix) {
        this.tempFileSuffix = tempFileSuffix;
    }

    public boolean isAutoCreateDirectory() {
        return this.autoCreateDirectory;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }
}

