/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import javax.swing.Icon;

public abstract class AbstractArchiveDriver
implements ArchiveDriver,
Serializable {
    private final String encoding;
    private transient ThreadLocalEncoder encoder;
    private final Icon openIcon;
    private final Icon closedIcon;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractArchiveDriver(String encoding, Icon openIcon, Icon closedIcon) {
        this.encoding = encoding;
        this.encoder = new ThreadLocalEncoder();
        this.openIcon = openIcon;
        this.closedIcon = closedIcon;
        try {
            new String(new byte[0], encoding);
        }
        catch (UnsupportedEncodingException uee) {
            UnsupportedCharsetException uce = new UnsupportedCharsetException(encoding);
            uce.initCause(uee);
            throw uce;
        }
        boolean ok = this.encoder.canEncode("");
        if (!$assertionsDisabled && !ok) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!$assertionsDisabled && this.encoder != null) {
            throw new AssertionError();
        }
        this.encoder = new ThreadLocalEncoder();
        if (!$assertionsDisabled && !this.invariants()) {
            throw new AssertionError();
        }
    }

    private boolean invariants() {
        if (!$assertionsDisabled && this.getEncoding() == null) {
            throw new AssertionError();
        }
        try {
            this.ensureEncodable("");
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
        return true;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    protected final void ensureEncodable(String entryName) throws CharConversionException {
        if (!this.encoder.canEncode(entryName)) {
            throw new CharConversionException(entryName + " (illegal characters in entry name)");
        }
    }

    public Icon getOpenIcon(Archive archive) {
        return this.openIcon;
    }

    public Icon getClosedIcon(Archive archive) {
        return this.closedIcon;
    }

    static {
        $assertionsDisabled = !AbstractArchiveDriver.class.desiredAssertionStatus();
    }

    private final class ThreadLocalEncoder
    extends ThreadLocal {
        private ThreadLocalEncoder() {
        }

        protected Object initialValue() {
            return Charset.forName(AbstractArchiveDriver.this.getEncoding()).newEncoder();
        }

        public boolean canEncode(CharSequence cs) {
            return ((CharsetEncoder)this.get()).canEncode(cs);
        }
    }
}

