/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.MultiplexedOutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.ReadOnlyFileInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;

public class TarDriver
extends AbstractArchiveDriver {
    private static final long serialVersionUID = 6622746562629104174L;
    static final String TEMP_FILE_PREFIX = "tzp-tar";
    public static final String ENCODING = "US-ASCII";

    public TarDriver() {
        super(ENCODING, null, null);
    }

    public TarDriver(String encoding) {
        super(encoding, null, null);
    }

    public TarDriver(String encoding, Icon openIcon, Icon closedIcon) {
        super(encoding, openIcon, closedIcon);
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String entryName, ArchiveEntry blueprint) throws CharConversionException {
        TarEntry entry;
        this.ensureEncodable(entryName);
        if (blueprint != null) {
            if (blueprint instanceof TarEntry) {
                entry = new TarEntry((TarEntry)blueprint);
                entry.setName(entryName);
            } else {
                entry = new TarEntry(entryName);
                entry.setTime(blueprint.getTime());
                entry.setSize(blueprint.getSize());
            }
        } else {
            entry = new TarEntry(entryName);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputArchive createInputArchive(Archive archive, ReadOnlyFile rof) throws IOException {
        InputStream in = this.createInputStream(archive, rof);
        try {
            TarInputArchive tarInputArchive = this.createTarInputArchive(archive, in);
            return tarInputArchive;
        }
        finally {
            in.close();
        }
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile rof) throws IOException {
        return new ReadOnlyFileInputStream(rof);
    }

    protected TarInputArchive createTarInputArchive(Archive archive, InputStream in) throws IOException {
        return new TarInputArchive(in);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream out, InputArchive source) throws IOException {
        return new MultiplexedOutputArchive(this.createTarOutputArchive(archive, out, (TarInputArchive)source));
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream out, TarInputArchive source) throws IOException {
        return new TarOutputArchive(out);
    }
}

